/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.parser;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.Stack;
import jodd.lagarto.EmptyTagVisitor;
import jodd.lagarto.LagartoException;
import jodd.lagarto.LagartoParser;
import jodd.lagarto.LagartoParserConfig;
import jodd.lagarto.Tag;
import jodd.lagarto.TagUtil;
import jodd.lagarto.TagVisitor;
import jodd.lagarto.dom.HtmlCCommentExpressionMatcher;
import jodd.log.LoggerFactory;
import jodd.log.LoggerFactoryInterface;
import jodd.log.impl.Slf4jLoggerFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.protocol.http.parser.HTMLParseException;
import org.apache.jmeter.protocol.http.parser.HTMLParser;
import org.apache.jmeter.protocol.http.parser.HtmlParsingUtils;
import org.apache.jmeter.protocol.http.parser.URLCollection;
import org.apache.jmeter.protocol.http.util.ConversionUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class LagartoBasedHtmlParser
extends HTMLParser {
    private static final Logger log = LoggingManager.getLoggerForClass();

    @Override
    public Iterator<URL> getEmbeddedResourceURLs(String userAgent, byte[] html, URL baseUrl, URLCollection coll, String encoding) throws HTMLParseException {
        try {
            Float ieVersion = this.extractIEVersion(userAgent);
            String contents = new String(html, encoding);
            LagartoParser lagartoParser = new LagartoParser(contents, false);
            LagartoParserConfig config = new LagartoParserConfig();
            config.setCaseSensitive(false);
            config.setEnableConditionalComments(this.isEnableConditionalComments(ieVersion));
            lagartoParser.setConfig(config);
            JMeterTagVisitor tagVisitor = new JMeterTagVisitor(new URLPointer(baseUrl), coll, ieVersion);
            lagartoParser.parse((TagVisitor)tagVisitor);
            return coll.iterator();
        }
        catch (LagartoException e) {
            if (log.isDebugEnabled()) {
                log.debug("Error extracting embedded resource URLs from:'" + baseUrl + "', probably not text content, message:" + e.getMessage());
            }
            return Collections.emptyList().iterator();
        }
        catch (Exception e) {
            throw new HTMLParseException(e);
        }
    }

    static {
        LoggerFactory.setLoggerFactory((LoggerFactoryInterface)new Slf4jLoggerFactory());
    }

    private static final class JMeterTagVisitor
    extends EmptyTagVisitor {
        private HtmlCCommentExpressionMatcher htmlCCommentExpressionMatcher;
        private URLCollection urls;
        private URLPointer baseUrl;
        private Float ieVersion;
        private Stack<Boolean> enabled = new Stack();

        public JMeterTagVisitor(URLPointer baseUrl, URLCollection urls, Float ieVersion) {
            this.urls = urls;
            this.baseUrl = baseUrl;
            this.ieVersion = ieVersion;
        }

        private void extractAttribute(Tag tag, String attributeName) {
            CharSequence url = tag.getAttributeValue((CharSequence)attributeName);
            if (!StringUtils.isEmpty((CharSequence)url)) {
                this.urls.addURL(url.toString(), this.baseUrl.url);
            }
        }

        public void script(Tag tag, CharSequence body) {
            if (!this.enabled.peek().booleanValue()) {
                return;
            }
            this.extractAttribute(tag, "src");
        }

        /*
         * Unable to fully structure code
         */
        public void tag(Tag tag) {
            if (!this.enabled.peek().booleanValue()) {
                return;
            }
            tagType = tag.getType();
            switch (1.$SwitchMap$jodd$lagarto$TagType[tagType.ordinal()]) {
                case 1: 
                case 2: {
                    if (tag.nameEquals((CharSequence)"body")) {
                        this.extractAttribute(tag, "background");
                    } else if (tag.nameEquals((CharSequence)"base")) {
                        baseref = tag.getAttributeValue((CharSequence)"href");
                        try {
                            if (StringUtils.isEmpty((CharSequence)baseref)) ** GOTO lbl51
                            URLPointer.access$002(this.baseUrl, ConversionUtils.makeRelativeURL(URLPointer.access$000(this.baseUrl), baseref.toString()));
                        }
                        catch (MalformedURLException e1) {
                            throw new RuntimeException(e1);
                        }
                    } else if (tag.nameEquals((CharSequence)"img")) {
                        this.extractAttribute(tag, "src");
                    } else if (tag.nameEquals((CharSequence)"applet")) {
                        this.extractAttribute(tag, "code");
                    } else if (tag.nameEquals((CharSequence)"object")) {
                        this.extractAttribute(tag, "codebase");
                        this.extractAttribute(tag, "data");
                    } else if (tag.nameEquals((CharSequence)"input")) {
                        type = tag.getAttributeValue((CharSequence)"type");
                        if (type != null && TagUtil.equalsIgnoreCase((CharSequence)"image", (CharSequence)type)) {
                            this.extractAttribute(tag, "src");
                        }
                    } else if (tag.nameEquals((CharSequence)"script")) {
                        this.extractAttribute(tag, "src");
                    } else if (tag.nameEquals((CharSequence)"frame") || tag.nameEquals((CharSequence)"iframe")) {
                        this.extractAttribute(tag, "src");
                    } else if (tag.nameEquals((CharSequence)"embed")) {
                        this.extractAttribute(tag, "src");
                    } else if (tag.nameEquals((CharSequence)"bgsound")) {
                        this.extractAttribute(tag, "src");
                    } else if (tag.nameEquals((CharSequence)"link")) {
                        relAttribute = tag.getAttributeValue((CharSequence)"rel");
                        if (relAttribute != null && TagUtil.equalsIgnoreCase((CharSequence)"stylesheet", (CharSequence)relAttribute)) {
                            this.extractAttribute(tag, "href");
                        }
                    } else {
                        this.extractAttribute(tag, "background");
                    }
lbl51:
                    // 13 sources

                    styleTagStr = tag.getAttributeValue((CharSequence)"style");
                    if (StringUtils.isEmpty((CharSequence)styleTagStr)) break;
                    HtmlParsingUtils.extractStyleURLs(URLPointer.access$000(this.baseUrl), this.urls, styleTagStr.toString());
                    break;
                }
                case 3: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected tagType " + tagType);
                }
            }
        }

        public void condComment(CharSequence expression, boolean isStartingTag, boolean isHidden, boolean isHiddenEndTag) {
            if (!isStartingTag) {
                this.enabled.pop();
            } else {
                if (this.htmlCCommentExpressionMatcher == null) {
                    this.htmlCCommentExpressionMatcher = new HtmlCCommentExpressionMatcher();
                }
                String expressionString = expression.toString().trim();
                this.enabled.push(this.htmlCCommentExpressionMatcher.match(this.ieVersion.floatValue(), expressionString));
            }
        }

        public void start() {
            super.start();
            this.enabled.clear();
            this.enabled.push(Boolean.TRUE);
        }
    }

    private static class URLPointer {
        private URL url;

        private URLPointer(URL newUrl) {
            this.url = newUrl;
        }

        static /* synthetic */ URL access$002(URLPointer x0, URL x1) {
            x0.url = x1;
            return x0.url;
        }
    }
}

