/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.sampler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.engine.event.LoopIterationEvent;
import org.apache.jmeter.protocol.http.control.AuthManager;
import org.apache.jmeter.protocol.http.control.CacheManager;
import org.apache.jmeter.protocol.http.control.Cookie;
import org.apache.jmeter.protocol.http.control.CookieManager;
import org.apache.jmeter.protocol.http.control.DNSCacheManager;
import org.apache.jmeter.protocol.http.control.HeaderManager;
import org.apache.jmeter.protocol.http.parser.BaseParser;
import org.apache.jmeter.protocol.http.parser.LinkExtractorParseException;
import org.apache.jmeter.protocol.http.parser.LinkExtractorParser;
import org.apache.jmeter.protocol.http.sampler.HTTPSampleResult;
import org.apache.jmeter.protocol.http.sampler.ResourcesDownloader;
import org.apache.jmeter.protocol.http.util.ConversionUtils;
import org.apache.jmeter.protocol.http.util.HTTPArgument;
import org.apache.jmeter.protocol.http.util.HTTPConstantsInterface;
import org.apache.jmeter.protocol.http.util.HTTPFileArg;
import org.apache.jmeter.protocol.http.util.HTTPFileArgs;
import org.apache.jmeter.samplers.AbstractSampler;
import org.apache.jmeter.samplers.Entry;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestIterationListener;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.testelement.property.BooleanProperty;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.IntegerProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.threads.JMeterContext;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;
import org.apache.oro.text.MalformedCachePatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Matcher;

public abstract class HTTPSamplerBase
extends AbstractSampler
implements TestStateListener,
TestIterationListener,
ThreadListener,
HTTPConstantsInterface {
    private static final long serialVersionUID = 241L;
    private static final Logger log;
    private static final Set<String> APPLIABLE_CONFIG_CLASSES;
    public static final String ARGUMENTS = "HTTPsampler.Arguments";
    public static final String AUTH_MANAGER = "HTTPSampler.auth_manager";
    public static final String COOKIE_MANAGER = "HTTPSampler.cookie_manager";
    public static final String CACHE_MANAGER = "HTTPSampler.cache_manager";
    public static final String HEADER_MANAGER = "HTTPSampler.header_manager";
    public static final String DNS_CACHE_MANAGER = "HTTPSampler.dns_cache_manager";
    public static final String DOMAIN = "HTTPSampler.domain";
    public static final String PORT = "HTTPSampler.port";
    public static final String PROXYHOST = "HTTPSampler.proxyHost";
    public static final String PROXYPORT = "HTTPSampler.proxyPort";
    public static final String PROXYUSER = "HTTPSampler.proxyUser";
    public static final String PROXYPASS = "HTTPSampler.proxyPass";
    public static final String CONNECT_TIMEOUT = "HTTPSampler.connect_timeout";
    public static final String RESPONSE_TIMEOUT = "HTTPSampler.response_timeout";
    public static final String METHOD = "HTTPSampler.method";
    public static final String CONTENT_ENCODING = "HTTPSampler.contentEncoding";
    public static final String IMPLEMENTATION = "HTTPSampler.implementation";
    public static final String PATH = "HTTPSampler.path";
    public static final String FOLLOW_REDIRECTS = "HTTPSampler.follow_redirects";
    public static final String AUTO_REDIRECTS = "HTTPSampler.auto_redirects";
    public static final String PROTOCOL = "HTTPSampler.protocol";
    static final String PROTOCOL_FILE = "file";
    private static final String DEFAULT_PROTOCOL = "http";
    public static final String URL = "HTTPSampler.URL";
    public static final String IP_SOURCE = "HTTPSampler.ipSource";
    public static final String IP_SOURCE_TYPE = "HTTPSampler.ipSourceType";
    public static final String USE_KEEPALIVE = "HTTPSampler.use_keepalive";
    public static final String DO_MULTIPART_POST = "HTTPSampler.DO_MULTIPART_POST";
    public static final String BROWSER_COMPATIBLE_MULTIPART = "HTTPSampler.BROWSER_COMPATIBLE_MULTIPART";
    public static final String CONCURRENT_DWN = "HTTPSampler.concurrentDwn";
    public static final String CONCURRENT_POOL = "HTTPSampler.concurrentPool";
    public static final int CONCURRENT_POOL_SIZE = 6;
    private static final String CONCURRENT_POOL_DEFAULT;
    private static final String USER_AGENT = "User-Agent";
    public static final boolean BROWSER_COMPATIBLE_MULTIPART_MODE_DEFAULT = false;
    private static final boolean IGNORE_FAILED_EMBEDDED_RESOURCES;
    private static final boolean IGNORE_EMBEDDED_RESOURCES_DATA;
    public static final int SOURCE_TYPE_DEFAULT;
    public static final String DEFAULT_METHOD = "GET";
    private static final List<String> METHODLIST;
    private static final String FILE_ARGS = "HTTPsampler.Files";
    private static final String MIMETYPE = "HTTPSampler.mimetype";
    private static final String FILE_NAME = "HTTPSampler.FILE_NAME";
    private static final String FILE_FIELD = "HTTPSampler.FILE_FIELD";
    public static final String CONTENT_TYPE = "HTTPSampler.CONTENT_TYPE";
    public static final String IMAGE_PARSER = "HTTPSampler.image_parser";
    public static final String EMBEDDED_URL_RE = "HTTPSampler.embedded_url_re";
    public static final String MONITOR = "HTTPSampler.monitor";
    public static final String MD5 = "HTTPSampler.md5";
    public static final int UNSPECIFIED_PORT = 0;
    public static final String UNSPECIFIED_PORT_AS_STRING = "0";
    public static final int URL_UNSPECIFIED_PORT = -1;
    public static final String URL_UNSPECIFIED_PORT_AS_STRING = "-1";
    protected static final String NON_HTTP_RESPONSE_CODE = "Non HTTP response code";
    protected static final String NON_HTTP_RESPONSE_MESSAGE = "Non HTTP response message";
    public static final String POST_BODY_RAW = "HTTPSampler.postBodyRaw";
    public static final boolean POST_BODY_RAW_DEFAULT = false;
    private static final String ARG_VAL_SEP = "=";
    private static final String QRY_SEP = "&";
    private static final String QRY_PFX = "?";
    protected static final int MAX_REDIRECTS;
    protected static final int MAX_FRAME_DEPTH;
    private static final Map<String, String> PARSERS_FOR_CONTENT_TYPE;
    private static final String RESPONSE_PARSERS;
    private static final boolean REMOVESLASHDOTDOT;
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTPS_PREFIX = "https://";
    private static final boolean SEPARATE_CONTAINER;

    public static String[] getSourceTypeList() {
        SourceType[] types = SourceType.values();
        String[] displayStrings = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            displayStrings[i] = JMeterUtils.getResString((String)types[i].propertyName);
        }
        return displayStrings;
    }

    public HTTPSamplerBase() {
        this.setArguments(new Arguments());
    }

    public boolean getSendFileAsPostBody() {
        HTTPFileArg[] files = this.getHTTPFiles();
        return files.length == 1 && files[0].getPath().length() > 0 && files[0].getParamName().length() == 0;
    }

    public boolean getSendParameterValuesAsPostBody() {
        if (this.getPostBodyRaw()) {
            return true;
        }
        boolean noArgumentsHasName = true;
        PropertyIterator args = this.getArguments().iterator();
        while (args.hasNext()) {
            HTTPArgument arg = (HTTPArgument)args.next().getObjectValue();
            if (arg.getName() == null || arg.getName().length() <= 0) continue;
            noArgumentsHasName = false;
            break;
        }
        return noArgumentsHasName;
    }

    public boolean getUseMultipartForPost() {
        HTTPFileArg[] files = this.getHTTPFiles();
        return "POST".equals(this.getMethod()) && (this.getDoMultipartPost() || files.length > 0 && !this.getSendFileAsPostBody());
    }

    public void setProtocol(String value) {
        this.setProperty(PROTOCOL, value.toLowerCase(Locale.ENGLISH));
    }

    public String getProtocol() {
        String protocol = this.getPropertyAsString(PROTOCOL);
        if (protocol == null || protocol.length() == 0) {
            return DEFAULT_PROTOCOL;
        }
        return protocol;
    }

    public void setPath(String path) {
        this.setPath(path, "UTF-8");
    }

    public void setPath(String path, String contentEncoding) {
        boolean getOrDelete;
        boolean fullUrl = path.startsWith(HTTP_PREFIX) || path.startsWith(HTTPS_PREFIX);
        boolean bl = getOrDelete = DEFAULT_METHOD.equals(this.getMethod()) || "DELETE".equals(this.getMethod());
        if (!fullUrl && getOrDelete) {
            int index = path.indexOf(QRY_PFX);
            if (index > -1) {
                this.setProperty(PATH, path.substring(0, index));
                this.parseArguments(path.substring(index + 1), contentEncoding);
            } else {
                this.setProperty(PATH, path);
            }
        } else {
            this.setProperty(PATH, path);
        }
    }

    public String getPath() {
        String p = this.getPropertyAsString(PATH);
        return this.encodeSpaces(p);
    }

    public void setFollowRedirects(boolean value) {
        this.setProperty((JMeterProperty)new BooleanProperty(FOLLOW_REDIRECTS, value));
    }

    public boolean getFollowRedirects() {
        return this.getPropertyAsBoolean(FOLLOW_REDIRECTS);
    }

    public void setAutoRedirects(boolean value) {
        this.setProperty((JMeterProperty)new BooleanProperty(AUTO_REDIRECTS, value));
    }

    public boolean getAutoRedirects() {
        return this.getPropertyAsBoolean(AUTO_REDIRECTS);
    }

    public void setMethod(String value) {
        this.setProperty(METHOD, value);
    }

    public String getMethod() {
        return this.getPropertyAsString(METHOD);
    }

    public void setContentEncoding(String charsetName) {
        this.setProperty(CONTENT_ENCODING, charsetName);
    }

    public String getContentEncoding() {
        return this.getPropertyAsString(CONTENT_ENCODING);
    }

    public void setUseKeepAlive(boolean value) {
        this.setProperty((JMeterProperty)new BooleanProperty(USE_KEEPALIVE, value));
    }

    public boolean getUseKeepAlive() {
        return this.getPropertyAsBoolean(USE_KEEPALIVE);
    }

    public void setDoMultipartPost(boolean value) {
        this.setProperty((JMeterProperty)new BooleanProperty(DO_MULTIPART_POST, value));
    }

    public boolean getDoMultipartPost() {
        return this.getPropertyAsBoolean(DO_MULTIPART_POST, false);
    }

    public void setDoBrowserCompatibleMultipart(boolean value) {
        this.setProperty(BROWSER_COMPATIBLE_MULTIPART, value, false);
    }

    public boolean getDoBrowserCompatibleMultipart() {
        return this.getPropertyAsBoolean(BROWSER_COMPATIBLE_MULTIPART, false);
    }

    public void setMonitor(String value) {
        this.setProperty(MONITOR, value);
    }

    public void setMonitor(boolean truth) {
        this.setProperty(MONITOR, truth);
    }

    public String getMonitor() {
        return this.getPropertyAsString(MONITOR);
    }

    public boolean isMonitor() {
        return this.getPropertyAsBoolean(MONITOR);
    }

    public void setImplementation(String value) {
        this.setProperty(IMPLEMENTATION, value);
    }

    public String getImplementation() {
        return this.getPropertyAsString(IMPLEMENTATION);
    }

    public boolean useMD5() {
        return this.getPropertyAsBoolean(MD5, false);
    }

    public void setMD5(boolean truth) {
        this.setProperty(MD5, truth, false);
    }

    public void addEncodedArgument(String name, String value) {
        this.addEncodedArgument(name, value, ARG_VAL_SEP);
    }

    public void addEncodedArgument(String name, String value, String metaData, String contentEncoding) {
        String valueEncoded;
        if (log.isDebugEnabled()) {
            log.debug("adding argument: name: " + name + " value: " + value + " metaData: " + metaData + " contentEncoding: " + contentEncoding);
        }
        boolean nonEmptyEncoding = !StringUtils.isEmpty((CharSequence)contentEncoding);
        HTTPArgument arg = nonEmptyEncoding ? new HTTPArgument(name, value, metaData, true, contentEncoding) : new HTTPArgument(name, value, metaData, true);
        if (nonEmptyEncoding) {
            try {
                valueEncoded = arg.getEncodedValue(contentEncoding);
            }
            catch (UnsupportedEncodingException e) {
                log.warn("Unable to get encoded value using encoding " + contentEncoding);
                valueEncoded = arg.getEncodedValue();
            }
        } else {
            valueEncoded = arg.getEncodedValue();
        }
        if (arg.getName().equals(arg.getEncodedName()) && arg.getValue().equals(valueEncoded)) {
            arg.setAlwaysEncoded(false);
        }
        this.getArguments().addArgument((Argument)arg);
    }

    public void addEncodedArgument(String name, String value, String metaData) {
        this.addEncodedArgument(name, value, metaData, null);
    }

    public void addNonEncodedArgument(String name, String value, String metadata) {
        HTTPArgument arg = new HTTPArgument(name, value, metadata, false);
        arg.setAlwaysEncoded(false);
        this.getArguments().addArgument((Argument)arg);
    }

    public void addArgument(String name, String value) {
        this.getArguments().addArgument((Argument)new HTTPArgument(name, value));
    }

    public void addArgument(String name, String value, String metadata) {
        this.getArguments().addArgument((Argument)new HTTPArgument(name, value, metadata));
    }

    public boolean hasArguments() {
        return this.getArguments().getArgumentCount() > 0;
    }

    public void addTestElement(TestElement el) {
        if (el instanceof CookieManager) {
            this.setCookieManager((CookieManager)el);
        } else if (el instanceof CacheManager) {
            this.setCacheManager((CacheManager)el);
        } else if (el instanceof HeaderManager) {
            this.setHeaderManager((HeaderManager)el);
        } else if (el instanceof AuthManager) {
            this.setAuthManager((AuthManager)el);
        } else if (el instanceof DNSCacheManager) {
            this.setDNSResolver((DNSCacheManager)el);
        } else {
            super.addTestElement(el);
        }
    }

    public void clearTestElementChildren() {
        this.removeProperty(HEADER_MANAGER);
    }

    public void setPort(int value) {
        this.setProperty((JMeterProperty)new IntegerProperty(PORT, value));
    }

    public static int getDefaultPort(String protocol, int port) {
        if (port == -1) {
            if (protocol.equalsIgnoreCase(DEFAULT_PROTOCOL)) {
                return 80;
            }
            if (protocol.equalsIgnoreCase("https")) {
                return 443;
            }
        }
        return port;
    }

    public int getPortIfSpecified() {
        String port_s = this.getPropertyAsString(PORT, UNSPECIFIED_PORT_AS_STRING);
        try {
            return Integer.parseInt(port_s.trim());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public boolean isProtocolDefaultPort() {
        int port = this.getPortIfSpecified();
        String protocol = this.getProtocol();
        boolean isDefaultHTTPPort = DEFAULT_PROTOCOL.equalsIgnoreCase(protocol) && port == 80;
        boolean isDefaultHTTPSPort = "https".equalsIgnoreCase(protocol) && port == 443;
        return port == 0 || isDefaultHTTPPort || isDefaultHTTPSPort;
    }

    public int getPort() {
        int port = this.getPortIfSpecified();
        if (port == 0) {
            String prot = this.getProtocol();
            if ("https".equalsIgnoreCase(prot)) {
                return 443;
            }
            if (!DEFAULT_PROTOCOL.equalsIgnoreCase(prot)) {
                log.warn("Unexpected protocol: " + prot);
            }
            return 80;
        }
        return port;
    }

    public void setDomain(String value) {
        this.setProperty(DOMAIN, value);
    }

    public String getDomain() {
        return this.getPropertyAsString(DOMAIN);
    }

    public void setConnectTimeout(String value) {
        this.setProperty(CONNECT_TIMEOUT, value, "");
    }

    public int getConnectTimeout() {
        return this.getPropertyAsInt(CONNECT_TIMEOUT, 0);
    }

    public void setResponseTimeout(String value) {
        this.setProperty(RESPONSE_TIMEOUT, value, "");
    }

    public int getResponseTimeout() {
        return this.getPropertyAsInt(RESPONSE_TIMEOUT, 0);
    }

    public String getProxyHost() {
        return this.getPropertyAsString(PROXYHOST);
    }

    public int getProxyPortInt() {
        return this.getPropertyAsInt(PROXYPORT, 0);
    }

    public String getProxyUser() {
        return this.getPropertyAsString(PROXYUSER);
    }

    public String getProxyPass() {
        return this.getPropertyAsString(PROXYPASS);
    }

    public final void setArguments(Arguments value) {
        this.setProperty((JMeterProperty)new TestElementProperty(ARGUMENTS, (TestElement)value));
    }

    public Arguments getArguments() {
        return (Arguments)this.getProperty(ARGUMENTS).getObjectValue();
    }

    public void setPostBodyRaw(boolean value) {
        this.setProperty(POST_BODY_RAW, value, false);
    }

    public boolean getPostBodyRaw() {
        return this.getPropertyAsBoolean(POST_BODY_RAW, false);
    }

    public void setAuthManager(AuthManager value) {
        AuthManager mgr = this.getAuthManager();
        if (mgr != null) {
            log.warn("Existing AuthManager " + mgr.getName() + " superseded by " + value.getName());
        }
        this.setProperty((JMeterProperty)new TestElementProperty(AUTH_MANAGER, (TestElement)value));
    }

    public AuthManager getAuthManager() {
        return (AuthManager)this.getProperty(AUTH_MANAGER).getObjectValue();
    }

    public void setHeaderManager(HeaderManager value) {
        HeaderManager mgr = this.getHeaderManager();
        if (mgr != null) {
            value = mgr.merge((TestElement)value, true);
            if (log.isDebugEnabled()) {
                log.debug("Existing HeaderManager '" + mgr.getName() + "' merged with '" + value.getName() + "'");
                for (int i = 0; i < value.getHeaders().size(); ++i) {
                    log.debug("    " + value.getHeader(i).getName() + ARG_VAL_SEP + value.getHeader(i).getValue());
                }
            }
        }
        this.setProperty((JMeterProperty)new TestElementProperty(HEADER_MANAGER, (TestElement)value));
    }

    public HeaderManager getHeaderManager() {
        return (HeaderManager)this.getProperty(HEADER_MANAGER).getObjectValue();
    }

    private void setCookieManagerProperty(CookieManager value) {
        this.setProperty((JMeterProperty)new TestElementProperty(COOKIE_MANAGER, (TestElement)value));
    }

    public void setCookieManager(CookieManager value) {
        CookieManager mgr = this.getCookieManager();
        if (mgr != null) {
            log.warn("Existing CookieManager " + mgr.getName() + " superseded by " + value.getName());
        }
        this.setCookieManagerProperty(value);
    }

    public CookieManager getCookieManager() {
        return (CookieManager)this.getProperty(COOKIE_MANAGER).getObjectValue();
    }

    private void setCacheManagerProperty(CacheManager value) {
        this.setProperty((JMeterProperty)new TestElementProperty(CACHE_MANAGER, (TestElement)value));
    }

    public void setCacheManager(CacheManager value) {
        CacheManager mgr = this.getCacheManager();
        if (mgr != null) {
            log.warn("Existing CacheManager " + mgr.getName() + " superseded by " + value.getName());
        }
        this.setCacheManagerProperty(value);
    }

    public CacheManager getCacheManager() {
        return (CacheManager)this.getProperty(CACHE_MANAGER).getObjectValue();
    }

    public DNSCacheManager getDNSResolver() {
        return (DNSCacheManager)this.getProperty(DNS_CACHE_MANAGER).getObjectValue();
    }

    public void setDNSResolver(DNSCacheManager cacheManager) {
        DNSCacheManager mgr = this.getDNSResolver();
        if (mgr != null) {
            log.warn("Existing DNSCacheManager " + mgr.getName() + " superseded by " + cacheManager.getName());
        }
        this.setProperty((JMeterProperty)new TestElementProperty(DNS_CACHE_MANAGER, (TestElement)cacheManager));
    }

    public boolean isImageParser() {
        return this.getPropertyAsBoolean(IMAGE_PARSER, false);
    }

    public void setImageParser(boolean parseImages) {
        this.setProperty(IMAGE_PARSER, parseImages, false);
    }

    public String getEmbeddedUrlRE() {
        return this.getPropertyAsString(EMBEDDED_URL_RE, "");
    }

    public void setEmbeddedUrlRE(String regex) {
        this.setProperty((JMeterProperty)new StringProperty(EMBEDDED_URL_RE, regex));
    }

    protected HTTPSampleResult errorResult(Throwable e, HTTPSampleResult res) {
        res.setSampleLabel(res.getSampleLabel());
        res.setDataType("text");
        ByteArrayOutputStream text = new ByteArrayOutputStream(200);
        e.printStackTrace(new PrintStream(text));
        res.setResponseData(text.toByteArray());
        res.setResponseCode("Non HTTP response code: " + e.getClass().getName());
        res.setResponseMessage("Non HTTP response message: " + e.getMessage());
        res.setSuccessful(false);
        res.setMonitor(this.isMonitor());
        return res;
    }

    public URL getUrl() throws MalformedURLException {
        String queryString;
        StringBuilder pathAndQuery = new StringBuilder(100);
        String path = this.getPath();
        if (path.startsWith(HTTP_PREFIX) || path.startsWith(HTTPS_PREFIX)) {
            return new URL(path);
        }
        String domain = this.getDomain();
        String protocol = this.getProtocol();
        if (PROTOCOL_FILE.equalsIgnoreCase(protocol)) {
            domain = null;
        } else if (!path.startsWith("/")) {
            pathAndQuery.append("/");
        }
        pathAndQuery.append(path);
        if ((DEFAULT_METHOD.equals(this.getMethod()) || "DELETE".equals(this.getMethod())) && (queryString = this.getQueryString(this.getContentEncoding())).length() > 0) {
            if (path.contains(QRY_PFX)) {
                pathAndQuery.append(QRY_SEP);
            } else {
                pathAndQuery.append(QRY_PFX);
            }
            pathAndQuery.append(queryString);
        }
        if (this.isProtocolDefaultPort()) {
            return new URL(protocol, domain, pathAndQuery.toString());
        }
        return new URL(protocol, domain, this.getPort(), pathAndQuery.toString());
    }

    public String getQueryString() {
        return this.getQueryString("UTF-8");
    }

    public String getQueryString(String contentEncoding) {
        if (JOrphanUtils.isBlank((String)contentEncoding)) {
            contentEncoding = "UTF-8";
        }
        StringBuilder buf = new StringBuilder();
        PropertyIterator iter = this.getArguments().iterator();
        boolean first = true;
        while (iter.hasNext()) {
            String encodedName;
            HTTPArgument item = null;
            Object objectValue = iter.next().getObjectValue();
            try {
                item = (HTTPArgument)objectValue;
            }
            catch (ClassCastException e) {
                log.warn("Unexpected argument type: " + objectValue.getClass().getName());
                item = new HTTPArgument((Argument)objectValue);
            }
            if ((encodedName = item.getEncodedName()).length() == 0) continue;
            if (!first) {
                buf.append(QRY_SEP);
            } else {
                first = false;
            }
            buf.append(encodedName);
            if (item.getMetaData() == null) {
                buf.append(ARG_VAL_SEP);
            } else {
                buf.append(item.getMetaData());
            }
            try {
                buf.append(item.getEncodedValue(contentEncoding));
            }
            catch (UnsupportedEncodingException e) {
                log.warn("Unable to encode parameter in encoding " + contentEncoding + ", parameter value not included in query string");
            }
        }
        return buf.toString();
    }

    public void parseArguments(String queryString, String contentEncoding) {
        String[] args = JOrphanUtils.split((String)queryString, (String)QRY_SEP);
        boolean isDebug = log.isDebugEnabled();
        for (String arg : args) {
            String value;
            String name;
            String metaData;
            if (isDebug) {
                log.debug("Arg: " + arg);
            }
            int length = arg.length();
            int endOfNameIndex = arg.indexOf(ARG_VAL_SEP);
            if (endOfNameIndex != -1) {
                metaData = ARG_VAL_SEP;
                name = arg.substring(0, endOfNameIndex);
                value = arg.substring(endOfNameIndex + 1, length);
            } else {
                metaData = "";
                name = arg;
                value = "";
            }
            if (name.length() <= 0) continue;
            if (isDebug) {
                log.debug("Name: " + name + " Value: " + value + " Metadata: " + metaData);
            }
            if (!StringUtils.isEmpty((CharSequence)contentEncoding)) {
                this.addEncodedArgument(name, value, metaData, contentEncoding);
                continue;
            }
            this.addNonEncodedArgument(name, value, metaData);
        }
    }

    public void parseArguments(String queryString) {
        this.parseArguments(queryString, null);
    }

    public String toString() {
        try {
            StringBuilder stringBuffer = new StringBuilder();
            stringBuffer.append(this.getUrl().toString());
            if ("POST".equals(this.getMethod()) || "PUT".equals(this.getMethod())) {
                stringBuffer.append("\nQuery Data: ");
                stringBuffer.append(this.getQueryString());
            }
            return stringBuffer.toString();
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    public SampleResult sample(Entry e) {
        return this.sample();
    }

    public SampleResult sample() {
        HTTPSampleResult res = null;
        try {
            res = this.sample(this.getUrl(), this.getMethod(), false, 0);
            if (res != null) {
                res.setSampleLabel(this.getName());
            }
            return res;
        }
        catch (Exception e) {
            return this.errorResult(e, new HTTPSampleResult());
        }
    }

    protected abstract HTTPSampleResult sample(URL var1, String var2, boolean var3, int var4);

    protected HTTPSampleResult downloadPageResources(HTTPSampleResult res, HTTPSampleResult container, int frameDepth) {
        Iterator<URL> urls = null;
        try {
            LinkExtractorParser parser;
            byte[] responseData = res.getResponseData();
            if (responseData.length > 0 && (parser = this.getParser(res)) != null) {
                String userAgent = this.getUserAgent(res);
                urls = parser.getEmbeddedResourceURLs(userAgent, responseData, res.getURL(), res.getDataEncodingWithDefault());
            }
        }
        catch (LinkExtractorParseException e) {
            res.addSubResult(this.errorResult(e, new HTTPSampleResult(res)));
            this.setParentSampleSuccess(res, false);
        }
        if (urls != null && urls.hasNext()) {
            if (container == null) {
                container = new HTTPSampleResult(res);
                container.addRawSubResult(res);
            }
            res = container;
            String re = this.getEmbeddedUrlRE();
            Perl5Matcher localMatcher = null;
            Pattern pattern = null;
            if (re.length() > 0) {
                try {
                    pattern = JMeterUtils.getPattern((String)re);
                    localMatcher = JMeterUtils.getMatcher();
                }
                catch (MalformedCachePatternException e) {
                    log.warn("Ignoring embedded URL match string: " + e.getMessage());
                }
            }
            ArrayList<Callable<ResourcesDownloader.AsynSamplerResultHolder>> list = new ArrayList<Callable<ResourcesDownloader.AsynSamplerResultHolder>>();
            int maxConcurrentDownloads = 6;
            boolean isConcurrentDwn = this.isConcurrentDwn();
            if (isConcurrentDwn) {
                try {
                    maxConcurrentDownloads = Integer.parseInt(this.getConcurrentPool());
                }
                catch (NumberFormatException nfe) {
                    log.warn("Concurrent download resources selected, but pool size value is bad. Use default value");
                }
                if (maxConcurrentDownloads == 1) {
                    log.warn("Number of parallel downloads set to 1, (sampler name=" + this.getName() + ")");
                    isConcurrentDwn = false;
                }
            }
            while (urls.hasNext()) {
                URL binURL = urls.next();
                try {
                    String urlStrEnc;
                    URL url = binURL;
                    if (url == null) {
                        log.warn("Null URL detected (should not happen)");
                        continue;
                    }
                    String urlstr = url.toString();
                    if (!urlstr.equals(urlStrEnc = this.escapeIllegalURLCharacters(this.encodeSpaces(urlstr)))) {
                        try {
                            url = new URL(urlStrEnc);
                        }
                        catch (MalformedURLException e) {
                            res.addSubResult(this.errorResult(new Exception(urlStrEnc + " is not a correct URI"), new HTTPSampleResult(res)));
                            this.setParentSampleSuccess(res, false);
                            continue;
                        }
                    }
                    if (pattern != null && localMatcher != null && !localMatcher.matches(urlStrEnc, pattern)) continue;
                    try {
                        url = url.toURI().normalize().toURL();
                    }
                    catch (MalformedURLException | URISyntaxException e) {
                        res.addSubResult(this.errorResult(new Exception(urlStrEnc + " URI can not be normalized", e), new HTTPSampleResult(res)));
                        this.setParentSampleSuccess(res, false);
                        continue;
                    }
                    if (isConcurrentDwn) {
                        list.add(new ASyncSample(url, DEFAULT_METHOD, false, frameDepth + 1, this.getCookieManager(), this));
                        continue;
                    }
                    HTTPSampleResult binRes = this.sample(url, DEFAULT_METHOD, false, frameDepth + 1);
                    res.addSubResult(binRes);
                    this.setParentSampleSuccess(res, res.isSuccessful() && (binRes == null || binRes.isSuccessful()));
                }
                catch (ClassCastException e) {
                    res.addSubResult(this.errorResult(new Exception(binURL + " is not a correct URI"), new HTTPSampleResult(res)));
                    this.setParentSampleSuccess(res, false);
                }
            }
            if (isConcurrentDwn && !list.isEmpty()) {
                ResourcesDownloader resourcesDownloader = ResourcesDownloader.getInstance();
                try {
                    List<Future<ResourcesDownloader.AsynSamplerResultHolder>> retExec = resourcesDownloader.invokeAllAndAwaitTermination(maxConcurrentDownloads, list);
                    CookieManager cookieManager = this.getCookieManager();
                    for (Future<ResourcesDownloader.AsynSamplerResultHolder> future : retExec) {
                        ResourcesDownloader.AsynSamplerResultHolder binRes = future.get();
                        if (cookieManager != null) {
                            CollectionProperty cookies = binRes.getCookies();
                            for (JMeterProperty jMeterProperty : cookies) {
                                Cookie cookie = (Cookie)jMeterProperty.getObjectValue();
                                cookieManager.add(cookie);
                            }
                        }
                        res.addSubResult(binRes.getResult());
                        this.setParentSampleSuccess(res, res.isSuccessful() && (binRes.getResult() == null || binRes.getResult().isSuccessful()));
                    }
                }
                catch (InterruptedException ie) {
                    log.warn("Interrupted fetching embedded resources", (Throwable)ie);
                }
                catch (ExecutionException ee) {
                    log.warn("Execution issue when fetching embedded resources", (Throwable)ee);
                }
            }
        }
        return res;
    }

    private LinkExtractorParser getParser(HTTPSampleResult res) throws LinkExtractorParseException {
        String parserClassName = PARSERS_FOR_CONTENT_TYPE.get(res.getMediaType());
        if (!StringUtils.isEmpty((CharSequence)parserClassName)) {
            return BaseParser.getParser(parserClassName);
        }
        return null;
    }

    private String escapeIllegalURLCharacters(String url) {
        if (url == null || url.toLowerCase().startsWith("file:")) {
            return url;
        }
        try {
            String escapedUrl = ConversionUtils.escapeIllegalURLCharacters(url);
            if (!escapedUrl.equals(url) && log.isDebugEnabled()) {
                log.debug("Url '" + url + "' has been escaped to '" + escapedUrl + "'. Please correct your webpage.");
            }
            return escapedUrl;
        }
        catch (Exception e1) {
            log.error("Error escaping URL:'" + url + "', message:" + e1.getMessage());
            return url;
        }
    }

    private String getUserAgent(HTTPSampleResult sampleResult) {
        String res = sampleResult.getRequestHeaders();
        int index = res.indexOf(USER_AGENT);
        if (index >= 0) {
            String userAgentPrefix = "User-Agent: ";
            String userAgentHdr = res.substring(index + "User-Agent: ".length(), res.indexOf(10, index + "User-Agent: ".length() + 1));
            return userAgentHdr.trim();
        }
        if (log.isInfoEnabled()) {
            log.info("No user agent extracted from requestHeaders:" + res);
        }
        return null;
    }

    private void setParentSampleSuccess(HTTPSampleResult res, boolean initialValue) {
        if (!IGNORE_FAILED_EMBEDDED_RESOURCES) {
            res.setSuccessful(initialValue);
            if (!initialValue) {
                StringBuilder detailedMessage = new StringBuilder(80);
                detailedMessage.append("Embedded resource download error:");
                for (SampleResult subResult : res.getSubResults()) {
                    HTTPSampleResult httpSampleResult = (HTTPSampleResult)subResult;
                    if (httpSampleResult.isSuccessful()) continue;
                    detailedMessage.append(httpSampleResult.getURL()).append(" code:").append(httpSampleResult.getResponseCode()).append(" message:").append(httpSampleResult.getResponseMessage()).append(", ");
                }
                res.setResponseMessage(detailedMessage.toString());
            }
        }
    }

    protected String encodeSpaces(String path) {
        return JOrphanUtils.replaceAllChars((String)path, (char)' ', (String)"%20");
    }

    public void testEnded() {
    }

    public void testEnded(String host) {
        this.testEnded();
    }

    public void testStarted() {
    }

    public void testStarted(String host) {
        this.testStarted();
    }

    public Object clone() {
        HTTPSamplerBase base = (HTTPSamplerBase)super.clone();
        return base;
    }

    protected HTTPSampleResult followRedirects(HTTPSampleResult res, int frameDepth) {
        int redirect;
        HTTPSampleResult totalRes = new HTTPSampleResult(res);
        totalRes.addRawSubResult(res);
        HTTPSampleResult lastRes = res;
        for (redirect = 0; redirect < MAX_REDIRECTS; ++redirect) {
            boolean invalidRedirectUrl = false;
            String location = lastRes.getRedirectLocation();
            if (log.isDebugEnabled()) {
                log.debug("Initial location: " + location);
            }
            if (REMOVESLASHDOTDOT) {
                location = ConversionUtils.removeSlashDotDot(location);
            }
            location = this.encodeSpaces(location);
            if (log.isDebugEnabled()) {
                log.debug("Location after /. and space transforms: " + location);
            }
            String method = lastRes.getHTTPMethod();
            method = this.computeMethodForRedirect(method, res.getResponseCode());
            try {
                HTTPSampleResult tempRes;
                URL url = ConversionUtils.makeRelativeURL(lastRes.getURL(), location);
                url = ConversionUtils.sanitizeUrl(url).toURL();
                if (log.isDebugEnabled()) {
                    log.debug("Location as URL: " + url.toString());
                }
                if ((tempRes = this.sample(url, method, true, frameDepth)) == null) break;
                lastRes = tempRes;
            }
            catch (MalformedURLException | URISyntaxException e) {
                this.errorResult(e, lastRes);
                invalidRedirectUrl = true;
            }
            if (lastRes.getSubResults() != null && lastRes.getSubResults().length > 0) {
                SampleResult[] subs;
                for (SampleResult sub : subs = lastRes.getSubResults()) {
                    totalRes.addSubResult(sub);
                }
            } else if (!invalidRedirectUrl) {
                totalRes.addSubResult(lastRes);
            }
            if (!lastRes.isRedirect()) break;
        }
        if (redirect >= MAX_REDIRECTS) {
            lastRes = this.errorResult(new IOException("Exceeded maximum number of redirects: " + MAX_REDIRECTS), new HTTPSampleResult(lastRes));
            totalRes.addSubResult(lastRes);
        }
        totalRes.setSampleLabel(totalRes.getSampleLabel() + "->" + lastRes.getSampleLabel());
        totalRes.setURL(lastRes.getURL());
        totalRes.setHTTPMethod(lastRes.getHTTPMethod());
        totalRes.setQueryString(lastRes.getQueryString());
        totalRes.setRequestHeaders(lastRes.getRequestHeaders());
        totalRes.setResponseData(lastRes.getResponseData());
        totalRes.setResponseCode(lastRes.getResponseCode());
        totalRes.setSuccessful(lastRes.isSuccessful());
        totalRes.setResponseMessage(lastRes.getResponseMessage());
        totalRes.setDataType(lastRes.getDataType());
        totalRes.setResponseHeaders(lastRes.getResponseHeaders());
        totalRes.setContentType(lastRes.getContentType());
        totalRes.setDataEncoding(lastRes.getDataEncodingNoDefault());
        return totalRes;
    }

    private String computeMethodForRedirect(String initialMethod, String responseCode) {
        if (!"HEAD".equalsIgnoreCase(initialMethod)) {
            return DEFAULT_METHOD;
        }
        return initialMethod;
    }

    protected HTTPSampleResult resultProcessing(boolean areFollowingRedirect, int frameDepth, HTTPSampleResult res) {
        boolean wasRedirected = false;
        if (!areFollowingRedirect && res.isRedirect()) {
            log.debug("Location set to - " + res.getRedirectLocation());
            if (this.getFollowRedirects()) {
                res = this.followRedirects(res, frameDepth);
                areFollowingRedirect = true;
                wasRedirected = true;
            }
        }
        if (this.isImageParser() && "text".equals(res.getDataType()) && res.isSuccessful()) {
            if (frameDepth > MAX_FRAME_DEPTH) {
                HTTPSampleResult errSubResult = new HTTPSampleResult(res);
                errSubResult.removeSubResults();
                res.addSubResult(this.errorResult(new Exception("Maximum frame/iframe nesting depth exceeded."), errSubResult));
            } else if (!wasRedirected) {
                HTTPSampleResult container = (HTTPSampleResult)((Object)(areFollowingRedirect ? res.getParent() : (SEPARATE_CONTAINER ? null : res)));
                res = this.downloadPageResources(res, container, frameDepth);
            }
        }
        return res;
    }

    protected boolean isSuccessCode(int code) {
        return code >= 200 && code <= 399;
    }

    protected static String encodeBackSlashes(String value) {
        StringBuilder newValue = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char charAt = value.charAt(i);
            if (charAt == '\\') {
                newValue.append("\\\\");
                continue;
            }
            newValue.append(charAt);
        }
        return newValue.toString();
    }

    private void setHTTPFileArgs(HTTPFileArgs value) {
        if (value.getHTTPFileArgCount() > 0) {
            this.setProperty((JMeterProperty)new TestElementProperty(FILE_ARGS, (TestElement)value));
        } else {
            this.removeProperty(FILE_ARGS);
        }
    }

    private HTTPFileArgs getHTTPFileArgs() {
        return (HTTPFileArgs)this.getProperty(FILE_ARGS).getObjectValue();
    }

    public HTTPFileArg[] getHTTPFiles() {
        HTTPFileArgs fileArgs = this.getHTTPFileArgs();
        return fileArgs == null ? new HTTPFileArg[]{} : fileArgs.asArray();
    }

    public int getHTTPFileCount() {
        return this.getHTTPFiles().length;
    }

    public void setHTTPFiles(HTTPFileArg[] files) {
        HTTPFileArgs fileArgs = new HTTPFileArgs();
        if (files.length > 0) {
            for (HTTPFileArg file : files) {
                if (!file.isNotEmpty()) continue;
                fileArgs.addHTTPFileArg(file);
            }
        }
        this.setHTTPFileArgs(fileArgs);
    }

    public static String[] getValidMethodsAsArray() {
        return METHODLIST.toArray(new String[METHODLIST.size()]);
    }

    public static boolean isSecure(String protocol) {
        return "https".equalsIgnoreCase(protocol);
    }

    public static boolean isSecure(URL url) {
        return HTTPSamplerBase.isSecure(url.getProtocol());
    }

    public void threadStarted() {
    }

    public void threadFinished() {
    }

    public void testIterationStart(LoopIterationEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readResponse(SampleResult sampleResult, InputStream in, int length) throws IOException {
        try {
            byte[] readBuffer = new byte[8192];
            int bufferSize = 32;
            MessageDigest md = null;
            boolean asMD5 = this.useMD5();
            if (asMD5) {
                try {
                    md = MessageDigest.getInstance("MD5");
                }
                catch (NoSuchAlgorithmException e) {
                    log.error("Should not happen - could not find MD5 digest", (Throwable)e);
                    asMD5 = false;
                }
            } else {
                bufferSize = length <= 0 ? 4096 : length;
            }
            ByteArrayOutputStream w = new ByteArrayOutputStream(bufferSize);
            int bytesRead = 0;
            int totalBytes = 0;
            boolean first = true;
            while ((bytesRead = in.read(readBuffer)) > -1) {
                if (first) {
                    sampleResult.latencyEnd();
                    first = false;
                }
                if (asMD5 && md != null) {
                    md.update(readBuffer, 0, bytesRead);
                    totalBytes += bytesRead;
                    continue;
                }
                w.write(readBuffer, 0, bytesRead);
            }
            if (first) {
                sampleResult.latencyEnd();
            }
            in.close();
            w.flush();
            if (asMD5 && md != null) {
                byte[] md5Result = md.digest();
                w.write(JOrphanUtils.baToHexBytes((byte[])md5Result));
                sampleResult.setBytes(totalBytes);
            }
            w.close();
            byte[] byArray = w.toByteArray();
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    void mergeFileProperties() {
        JMeterProperty fileName = this.getProperty(FILE_NAME);
        JMeterProperty paramName = this.getProperty(FILE_FIELD);
        JMeterProperty mimeType = this.getProperty(MIMETYPE);
        HTTPFileArg oldStyleFile = new HTTPFileArg(fileName, paramName, mimeType);
        HTTPFileArgs fileArgs = this.getHTTPFileArgs();
        HTTPFileArgs allFileArgs = new HTTPFileArgs();
        if (oldStyleFile.isNotEmpty()) {
            allFileArgs.addHTTPFileArg(oldStyleFile);
            if (fileArgs != null) {
                HTTPFileArg[] infiles;
                for (HTTPFileArg infile : infiles = fileArgs.asArray()) {
                    allFileArgs.addHTTPFileArg(infile);
                }
            }
        } else if (fileArgs != null) {
            allFileArgs = fileArgs;
        }
        this.setHTTPFileArgs(allFileArgs);
        this.removeProperty(FILE_FIELD);
        this.removeProperty(FILE_NAME);
        this.removeProperty(MIMETYPE);
    }

    public void setIpSource(String value) {
        this.setProperty(IP_SOURCE, value, "");
    }

    public String getIpSource() {
        return this.getPropertyAsString(IP_SOURCE, "");
    }

    public void setIpSourceType(int value) {
        this.setProperty(IP_SOURCE_TYPE, value, SOURCE_TYPE_DEFAULT);
    }

    public int getIpSourceType() {
        return this.getPropertyAsInt(IP_SOURCE_TYPE, SOURCE_TYPE_DEFAULT);
    }

    public boolean isConcurrentDwn() {
        return this.getPropertyAsBoolean(CONCURRENT_DWN, false);
    }

    public void setConcurrentDwn(boolean concurrentDwn) {
        this.setProperty(CONCURRENT_DWN, concurrentDwn, false);
    }

    public String getConcurrentPool() {
        return this.getPropertyAsString(CONCURRENT_POOL, CONCURRENT_POOL_DEFAULT);
    }

    public void setConcurrentPool(String poolSize) {
        this.setProperty(CONCURRENT_POOL, poolSize, CONCURRENT_POOL_DEFAULT);
    }

    public boolean applies(ConfigTestElement configElement) {
        String guiClass = configElement.getProperty("TestElement.gui_class").getStringValue();
        return APPLIABLE_CONFIG_CLASSES.contains(guiClass);
    }

    static {
        String[] parsers;
        log = LoggingManager.getLoggerForClass();
        APPLIABLE_CONFIG_CLASSES = new HashSet<String>(Arrays.asList("org.apache.jmeter.config.gui.LoginConfigGui", "org.apache.jmeter.protocol.http.config.gui.HttpDefaultsGui", "org.apache.jmeter.config.gui.SimpleConfigGui", "org.apache.jmeter.protocol.http.gui.HeaderPanel", "org.apache.jmeter.protocol.http.control.DNSCacheManager", "org.apache.jmeter.protocol.http.gui.DNSCachePanel", "org.apache.jmeter.protocol.http.gui.AuthPanel", "org.apache.jmeter.protocol.http.gui.CacheManagerGui", "org.apache.jmeter.protocol.http.gui.CookiePanel"));
        CONCURRENT_POOL_DEFAULT = Integer.toString(6);
        IGNORE_FAILED_EMBEDDED_RESOURCES = JMeterUtils.getPropDefault((String)"httpsampler.ignore_failed_embedded_resources", (boolean)false);
        IGNORE_EMBEDDED_RESOURCES_DATA = JMeterUtils.getPropDefault((String)"httpsampler.embedded_resources_use_md5", (boolean)false);
        SOURCE_TYPE_DEFAULT = SourceType.HOSTNAME.ordinal();
        ArrayList<String> defaultMethods = new ArrayList<String>(Arrays.asList(DEFAULT_METHOD, "POST", "HEAD", "PUT", "OPTIONS", "TRACE", "DELETE", "PATCH", "PROPFIND", "PROPPATCH", "MKCOL", "COPY", "MOVE", "LOCK", "UNLOCK", "REPORT", "MKCALENDAR", "SEARCH"));
        String userDefinedMethods = JMeterUtils.getPropDefault((String)"httpsampler.user_defined_methods", (String)"");
        if (StringUtils.isNotBlank((CharSequence)userDefinedMethods)) {
            defaultMethods.addAll(Arrays.asList(userDefinedMethods.split("\\s*,\\s*")));
        }
        METHODLIST = Collections.unmodifiableList(defaultMethods);
        MAX_REDIRECTS = JMeterUtils.getPropDefault((String)"httpsampler.max_redirects", (int)20);
        MAX_FRAME_DEPTH = JMeterUtils.getPropDefault((String)"httpsampler.max_frame_depth", (int)5);
        PARSERS_FOR_CONTENT_TYPE = new HashMap<String, String>();
        RESPONSE_PARSERS = JMeterUtils.getProperty((String)"HTTPResponse.parsers");
        for (String parser : parsers = JOrphanUtils.split((String)RESPONSE_PARSERS, (String)" ", (boolean)true)) {
            String classname = JMeterUtils.getProperty((String)(parser + ".className"));
            if (classname == null) {
                log.error("Cannot find .className property for " + parser + ", ensure you set property:'" + parser + ".className'");
                continue;
            }
            String typeList = JMeterUtils.getProperty((String)(parser + ".types"));
            if (typeList != null) {
                String[] types;
                for (String type : types = JOrphanUtils.split((String)typeList, (String)" ", (boolean)true)) {
                    log.info("Parser for " + type + " is " + classname);
                    PARSERS_FOR_CONTENT_TYPE.put(type, classname);
                }
                continue;
            }
            log.warn("Cannot find .types property for " + parser + ", as a consequence parser will not be used, to make it usable, define property:'" + parser + ".types'");
        }
        REMOVESLASHDOTDOT = JMeterUtils.getPropDefault((String)"httpsampler.redirect.removeslashdotdot", (boolean)true);
        SEPARATE_CONTAINER = JMeterUtils.getPropDefault((String)"httpsampler.separate.container", (boolean)true);
    }

    private static class ASyncSample
    implements Callable<ResourcesDownloader.AsynSamplerResultHolder> {
        private final URL url;
        private final String method;
        private final boolean areFollowingRedirect;
        private final int depth;
        private final HTTPSamplerBase sampler;
        private final JMeterContext jmeterContextOfParentThread;

        ASyncSample(URL url, String method, boolean areFollowingRedirect, int depth, CookieManager cookieManager, HTTPSamplerBase base) {
            this.url = url;
            this.method = method;
            this.areFollowingRedirect = areFollowingRedirect;
            this.depth = depth;
            this.sampler = (HTTPSamplerBase)base.clone();
            CacheManager cacheManager = base.getCacheManager();
            if (cacheManager != null) {
                this.sampler.setCacheManagerProperty(cacheManager.createCacheManagerProxy());
            }
            if (cookieManager != null) {
                CookieManager clonedCookieManager = (CookieManager)cookieManager.clone();
                this.sampler.setCookieManagerProperty(clonedCookieManager);
            }
            this.sampler.setMD5(this.sampler.useMD5() || IGNORE_EMBEDDED_RESOURCES_DATA);
            this.jmeterContextOfParentThread = JMeterContextService.getContext();
        }

        @Override
        public ResourcesDownloader.AsynSamplerResultHolder call() {
            JMeterContextService.replaceContext((JMeterContext)this.jmeterContextOfParentThread);
            HTTPSampleResult httpSampleResult = this.sampler.sample(this.url, this.method, this.areFollowingRedirect, this.depth);
            if (this.sampler.getCookieManager() != null) {
                CollectionProperty cookies = this.sampler.getCookieManager().getCookies();
                return new ResourcesDownloader.AsynSamplerResultHolder(httpSampleResult, cookies);
            }
            return new ResourcesDownloader.AsynSamplerResultHolder(httpSampleResult, new CollectionProperty());
        }
    }

    public static enum SourceType {
        HOSTNAME("web_testing_source_ip_hostname"),
        DEVICE("web_testing_source_ip_device"),
        DEVICE_IPV4("web_testing_source_ip_device_ipv4"),
        DEVICE_IPV6("web_testing_source_ip_device_ipv6");

        public final String propertyName;

        private SourceType(String propertyName) {
            this.propertyName = propertyName;
        }
    }
}

