/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jorphan.gui.JLabeledField;

public class JLabeledTextField
extends JPanel
implements JLabeledField,
FocusListener {
    private static final long serialVersionUID = 240L;
    private JLabel mLabel;
    private JTextField mTextField;
    private final ArrayList<ChangeListener> mChangeListeners = new ArrayList(3);
    private String oldValue = "";

    public JLabeledTextField() {
        this("", 20);
    }

    public JLabeledTextField(String pLabel) {
        this(pLabel, 20);
    }

    public JLabeledTextField(String pLabel, int size) {
        this.mTextField = this.createTextField(size);
        this.mLabel = new JLabel(pLabel);
        this.mLabel.setLabelFor(this.mTextField);
        this.init();
    }

    public JLabeledTextField(String pLabel, Color bk) {
        this.mTextField = this.createTextField(20);
        this.mLabel = new JLabel(pLabel);
        this.mLabel.setBackground(bk);
        this.mLabel.setLabelFor(this.mTextField);
        this.setBackground(bk);
        this.init();
    }

    @Override
    public List<JComponent> getComponentList() {
        LinkedList<JComponent> comps = new LinkedList<JComponent>();
        comps.add(this.mLabel);
        comps.add(this.mTextField);
        return comps;
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.mTextField.setEnabled(enable);
    }

    protected JTextField createTextField(int size) {
        return new JTextField(size);
    }

    private void init() {
        this.setLayout(new BorderLayout(5, 0));
        this.mTextField.addFocusListener(this);
        this.add((Component)this.mLabel, "West");
        this.add((Component)this.mTextField, "Center");
    }

    @Override
    public void focusLost(FocusEvent pFocusEvent) {
        if (!this.oldValue.equals(this.mTextField.getText())) {
            this.notifyChangeListeners();
        }
    }

    @Override
    public void focusGained(FocusEvent pFocusEvent) {
        this.oldValue = this.mTextField.getText();
    }

    @Override
    public void setLabel(String pLabel) {
        this.mLabel.setText(pLabel);
    }

    @Override
    public void setText(String pText) {
        this.mTextField.setText(pText);
    }

    @Override
    public String getText() {
        return this.mTextField.getText();
    }

    public String getLabel() {
        return this.mLabel.getText();
    }

    @Override
    public void setToolTipText(String text) {
        this.mLabel.setToolTipText(text);
        this.mTextField.setToolTipText(text);
    }

    @Override
    public String getToolTipText() {
        if (this.mTextField == null) {
            return null;
        }
        return this.mTextField.getToolTipText();
    }

    @Override
    public void addChangeListener(ChangeListener pChangeListener) {
        this.mChangeListeners.add(pChangeListener);
    }

    public void removeChangeListener(ChangeListener pChangeListener) {
        this.mChangeListeners.remove(pChangeListener);
    }

    protected void notifyChangeListeners() {
        ChangeEvent ce = new ChangeEvent(this);
        for (ChangeListener mChangeListener : this.mChangeListeners) {
            mChangeListener.stateChanged(ce);
        }
    }
}

