/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jorphan.util;

import org.apache.commons.collections.ArrayStack;

public class XMLBuffer {
    private final StringBuilder sb = new StringBuilder();
    private final ArrayStack tags = new ArrayStack();

    private void startTag(String t) {
        this.sb.append("<");
        this.sb.append(t);
        this.sb.append(">");
    }

    private void endTag(String t) {
        this.sb.append("</");
        this.sb.append(t);
        this.sb.append(">");
        this.sb.append("\n");
    }

    private void emptyTag(String t) {
        this.sb.append("<");
        this.sb.append(t);
        this.sb.append("/>");
        this.sb.append("\n");
    }

    public XMLBuffer openTag(String tagName) {
        this.tags.push((Object)tagName);
        this.startTag(tagName);
        return this;
    }

    public XMLBuffer closeTag(String tagName) {
        String tag = (String)this.tags.pop();
        if (!tag.equals(tagName)) {
            throw new IllegalArgumentException("Trying to close tag: " + tagName + " ; should be " + tag);
        }
        this.endTag(tag);
        return this;
    }

    public XMLBuffer tag(String tagName, CharSequence content) {
        if (content.length() == 0) {
            this.emptyTag(tagName);
        } else {
            this.startTag(tagName);
            this.sb.append(content);
            this.endTag(tagName);
        }
        return this;
    }

    public String toString() {
        while (!this.tags.isEmpty()) {
            this.endTag((String)this.tags.pop());
        }
        return this.sb.toString();
    }
}

