/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.decl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.css.CSSSourceLocation;
import com.helger.css.ECSSVersion;
import com.helger.css.ICSSSourceLocationAware;
import com.helger.css.ICSSVersionAware;
import com.helger.css.ICSSWriterSettings;
import com.helger.css.decl.CSSKeyframesBlock;
import com.helger.css.decl.ICSSTopLevelRule;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class CSSKeyframesRule
implements ICSSTopLevelRule,
ICSSVersionAware,
ICSSSourceLocationAware {
    private final String m_sDeclaration;
    private final String m_sAnimationName;
    private final List<CSSKeyframesBlock> m_aBlocks = new ArrayList<CSSKeyframesBlock>();
    private CSSSourceLocation m_aSourceLocation;

    public static boolean isValidDeclaration(@Nonnull @Nonempty String string) {
        return StringHelper.startsWith((CharSequence)string, (char)'@') && StringHelper.endsWithIgnoreCase((String)string, (String)"keyframes");
    }

    public CSSKeyframesRule(@Nonnull @Nonempty String string, @Nonnull @Nonempty String string2) {
        if (!CSSKeyframesRule.isValidDeclaration(string)) {
            throw new IllegalArgumentException("declaration");
        }
        this.m_sDeclaration = string;
        this.m_sAnimationName = string2;
    }

    @Nonnull
    @Nonempty
    public String getDeclaration() {
        return this.m_sDeclaration;
    }

    @Nonnull
    @Nonempty
    public String getAnimationName() {
        return this.m_sAnimationName;
    }

    public boolean hasBlocks() {
        return !this.m_aBlocks.isEmpty();
    }

    @Nonnegative
    public int getBlockCount() {
        return this.m_aBlocks.size();
    }

    @Nonnull
    public CSSKeyframesRule addBlock(@Nonnull CSSKeyframesBlock cSSKeyframesBlock) {
        ValueEnforcer.notNull((Object)cSSKeyframesBlock, (String)"KeyframesBlock");
        this.m_aBlocks.add(cSSKeyframesBlock);
        return this;
    }

    @Nonnull
    public CSSKeyframesRule addBlock(@Nonnegative int n, @Nonnull CSSKeyframesBlock cSSKeyframesBlock) {
        ValueEnforcer.isGE0((int)n, (String)"Index");
        ValueEnforcer.notNull((Object)cSSKeyframesBlock, (String)"KeyframesBlock");
        if (n >= this.getBlockCount()) {
            this.m_aBlocks.add(cSSKeyframesBlock);
        } else {
            this.m_aBlocks.add(n, cSSKeyframesBlock);
        }
        return this;
    }

    @Nonnull
    public EChange removeBlock(@Nonnull CSSKeyframesBlock cSSKeyframesBlock) {
        return EChange.valueOf((boolean)this.m_aBlocks.remove(cSSKeyframesBlock));
    }

    @Nonnull
    public EChange removeBlock(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aBlocks.size()) {
            return EChange.UNCHANGED;
        }
        return EChange.valueOf((this.m_aBlocks.remove(n) != null ? 1 : 0) != 0);
    }

    @Nonnull
    public EChange removeAllBlocks() {
        if (this.m_aBlocks.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.m_aBlocks.clear();
        return EChange.CHANGED;
    }

    @Nullable
    public CSSKeyframesBlock getBlockAtIndex(@Nonnegative int n) {
        if (n < 0 || n >= this.m_aBlocks.size()) {
            return null;
        }
        return this.m_aBlocks.get(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public List<CSSKeyframesBlock> getAllBlocks() {
        return CollectionHelper.newList(this.m_aBlocks);
    }

    @Override
    @Nonnull
    @Nonempty
    public String getAsCSSString(@Nonnull ICSSWriterSettings iCSSWriterSettings, @Nonnegative int n) {
        iCSSWriterSettings.checkVersionRequirements(this);
        if (!iCSSWriterSettings.isWriteKeyframesRules()) {
            return "";
        }
        if (iCSSWriterSettings.isRemoveUnnecessaryCode() && this.m_aBlocks.isEmpty()) {
            return "";
        }
        boolean bl = iCSSWriterSettings.isOptimizedOutput();
        StringBuilder stringBuilder = new StringBuilder(this.m_sDeclaration);
        stringBuilder.append(' ').append(this.m_sAnimationName).append(bl ? "{" : " {");
        if (!bl) {
            stringBuilder.append(iCSSWriterSettings.getNewLineString());
        }
        for (CSSKeyframesBlock cSSKeyframesBlock : this.m_aBlocks) {
            String string = cSSKeyframesBlock.getAsCSSString(iCSSWriterSettings, n + 1);
            if (!StringHelper.hasText((String)string)) continue;
            if (!bl) {
                stringBuilder.append(iCSSWriterSettings.getIndent(n + 1));
            }
            stringBuilder.append(string);
            if (bl) continue;
            stringBuilder.append(iCSSWriterSettings.getNewLineString());
        }
        if (!bl) {
            stringBuilder.append(iCSSWriterSettings.getIndent(n));
        }
        stringBuilder.append('}');
        if (!bl) {
            stringBuilder.append(iCSSWriterSettings.getNewLineString());
        }
        return stringBuilder.toString();
    }

    @Override
    @Nonnull
    public ECSSVersion getMinimumCSSVersion() {
        return ECSSVersion.CSS30;
    }

    @Override
    public void setSourceLocation(@Nullable CSSSourceLocation cSSSourceLocation) {
        this.m_aSourceLocation = cSSSourceLocation;
    }

    @Override
    @Nullable
    public CSSSourceLocation getSourceLocation() {
        return this.m_aSourceLocation;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSKeyframesRule cSSKeyframesRule = (CSSKeyframesRule)object;
        return this.m_sDeclaration.equals(cSSKeyframesRule.m_sDeclaration) && this.m_sAnimationName.equals(cSSKeyframesRule.m_sAnimationName) && this.m_aBlocks.equals(cSSKeyframesRule.m_aBlocks);
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append((Object)this.m_sDeclaration).append((Object)this.m_sAnimationName).append(this.m_aBlocks).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator((Object)this).append("declaration", (Object)this.m_sDeclaration).append("animationName", (Object)this.m_sAnimationName).append("blocks", this.m_aBlocks).appendIfNotNull("sourceLocation", (Object)this.m_aSourceLocation).toString();
    }
}

