/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css.tools;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.string.StringHelper;
import com.helger.css.ECSSVersion;
import com.helger.css.decl.CSSImportRule;
import com.helger.css.decl.CSSMediaQuery;
import com.helger.css.decl.CSSMediaRule;
import com.helger.css.decl.CSSNamespaceRule;
import com.helger.css.decl.CascadingStyleSheet;
import com.helger.css.decl.ICSSTopLevelRule;
import com.helger.css.reader.CSSReader;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class MediaQueryTools {
    private static final MediaQueryTools s_aInstance = new MediaQueryTools();

    private MediaQueryTools() {
    }

    @Nullable
    public static List<CSSMediaQuery> parseToMediaQuery(@Nullable String string, @Nonnull ECSSVersion eCSSVersion) {
        if (StringHelper.hasNoText((String)string)) {
            return null;
        }
        String string2 = "@media " + string + " {}";
        CascadingStyleSheet cascadingStyleSheet = CSSReader.readFromString(string2, eCSSVersion);
        if (cascadingStyleSheet == null) {
            return null;
        }
        CSSMediaRule cSSMediaRule = cascadingStyleSheet.getAllMediaRules().get(0);
        return cSSMediaRule.getAllMediaQueries();
    }

    public static boolean canWrapInMediaQuery(@Nullable CascadingStyleSheet cascadingStyleSheet, boolean bl) {
        if (cascadingStyleSheet == null) {
            return false;
        }
        if (bl) {
            return true;
        }
        return !cascadingStyleSheet.hasMediaRules();
    }

    @Nullable
    public static CascadingStyleSheet getWrappedInMediaQuery(@Nonnull CascadingStyleSheet cascadingStyleSheet, @Nonnull CSSMediaQuery cSSMediaQuery, boolean bl) {
        return MediaQueryTools.getWrappedInMediaQuery(cascadingStyleSheet, CollectionHelper.newList((Object)cSSMediaQuery), bl);
    }

    @Nullable
    public static CascadingStyleSheet getWrappedInMediaQuery(@Nonnull CascadingStyleSheet cascadingStyleSheet, @Nonnull @Nonempty Iterable<? extends CSSMediaQuery> iterable, boolean bl) {
        ValueEnforcer.notNull((Object)cascadingStyleSheet, (String)"CSS");
        ValueEnforcer.notEmpty(iterable, (String)"MediaQueries");
        if (!MediaQueryTools.canWrapInMediaQuery(cascadingStyleSheet, bl)) {
            return null;
        }
        CascadingStyleSheet cascadingStyleSheet2 = new CascadingStyleSheet();
        for (CSSImportRule object : cascadingStyleSheet.getAllImportRules()) {
            if (object.hasMediaQueries()) {
                cascadingStyleSheet2.addImportRule(object);
                continue;
            }
            CSSImportRule cSSImportRule = new CSSImportRule(object.getLocation());
            for (CSSMediaQuery cSSMediaQuery : iterable) {
                cSSImportRule.addMediaQuery(cSSMediaQuery);
            }
            cascadingStyleSheet2.addImportRule(cSSImportRule);
        }
        for (CSSNamespaceRule cSSNamespaceRule : cascadingStyleSheet.getAllNamespaceRules()) {
            cascadingStyleSheet2.addNamespaceRule(cSSNamespaceRule);
        }
        CSSMediaRule cSSMediaRule = new CSSMediaRule();
        for (CSSMediaQuery cSSMediaQuery : iterable) {
            cSSMediaRule.addMediaQuery(cSSMediaQuery);
        }
        for (ICSSTopLevelRule iCSSTopLevelRule : cascadingStyleSheet.getAllRules()) {
            cSSMediaRule.addRule(iCSSTopLevelRule);
        }
        cascadingStyleSheet2.addRule(cSSMediaRule);
        return cascadingStyleSheet2;
    }
}

