/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.lru;

import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.UseDirectEqualsAndHashCode;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@UseDirectEqualsAndHashCode
@NotThreadSafe
public class LRUMap<KEYTYPE, VALUETYPE>
extends LinkedHashMap<KEYTYPE, VALUETYPE> {
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private final int m_nMaxSize;

    public LRUMap(@Nonnegative int n) {
        super(n, 0.75f, true);
        this.m_nMaxSize = n;
    }

    @Nonnegative
    public final int getMaxSize() {
        return this.m_nMaxSize;
    }

    @OverrideOnDemand
    protected void onRemoveEldestEntry(@Nonnegative int n, @Nonnull Map.Entry<KEYTYPE, VALUETYPE> entry) {
    }

    @Override
    protected final boolean removeEldestEntry(@Nonnull Map.Entry<KEYTYPE, VALUETYPE> entry) {
        int n = this.size();
        if (n <= this.m_nMaxSize) {
            return false;
        }
        this.onRemoveEldestEntry(n, entry);
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        LRUMap lRUMap = (LRUMap)object;
        return EqualsHelper.equals(this.m_nMaxSize, lRUMap.m_nMaxSize) && this.entrySet().equals(lRUMap.entrySet());
    }

    @Override
    public int hashCode() {
        HashCodeGenerator hashCodeGenerator = new HashCodeGenerator(this).append(this.m_nMaxSize);
        for (Map.Entry entry : this.entrySet()) {
            hashCodeGenerator.append(entry.getKey()).append(entry.getValue());
        }
        return hashCodeGenerator.getHashCode();
    }

    @Override
    public String toString() {
        return new ToStringGenerator(this).append("maxSize", this.m_nMaxSize).append("map", super.toString()).toString();
    }
}

