/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.concurrent;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.callback.INonThrowingCallable;
import com.helger.commons.callback.IThrowingCallable;
import com.helger.commons.callback.IThrowingRunnable;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimpleLock
extends ReentrantLock {
    public SimpleLock() {
    }

    public SimpleLock(boolean bl) {
        super(bl);
    }

    public void locked(@Nonnull Runnable runnable) {
        ValueEnforcer.notNull(runnable, "Runnable");
        this.lock();
        try {
            runnable.run();
        }
        finally {
            this.unlock();
        }
    }

    public <EXTYPE extends Exception> void lockedThrowing(@Nonnull IThrowingRunnable<EXTYPE> iThrowingRunnable) throws EXTYPE {
        ValueEnforcer.notNull(iThrowingRunnable, "Runnable");
        this.lock();
        try {
            iThrowingRunnable.run();
        }
        finally {
            this.unlock();
        }
    }

    @Nullable
    public <T> T locked(@Nonnull INonThrowingCallable<T> iNonThrowingCallable) {
        ValueEnforcer.notNull(iNonThrowingCallable, "Supplier");
        this.lock();
        try {
            T t = iNonThrowingCallable.call();
            return t;
        }
        finally {
            this.unlock();
        }
    }

    @Nullable
    public <T, EXTYPE extends Exception> T lockedThrowing(@Nonnull IThrowingCallable<T, EXTYPE> iThrowingCallable) throws EXTYPE {
        ValueEnforcer.notNull(iThrowingCallable, "Callable");
        this.lock();
        try {
            T t = iThrowingCallable.call();
            return t;
        }
        finally {
            this.unlock();
        }
    }
}

