/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.concurrent.collector;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.callback.INonThrowingRunnable;
import com.helger.commons.concurrent.collector.IMutableConcurrentCollector;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.state.ESuccess;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractConcurrentCollector<DATATYPE>
implements INonThrowingRunnable,
IMutableConcurrentCollector<DATATYPE> {
    public static final int DEFAULT_MAX_QUEUE_SIZE = 100;
    public static final Object STOP_QUEUE_OBJECT = new Object();
    private static final Logger s_aLogger = LoggerFactory.getLogger(AbstractConcurrentCollector.class);
    private final ReadWriteLock m_aRWLock = new ReentrantReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    protected final BlockingQueue<Object> m_aQueue;
    @GuardedBy(value="m_aRWLock")
    private boolean m_bStopTakingNewObjects = false;

    public AbstractConcurrentCollector(@Nonnegative int n) {
        this(new ArrayBlockingQueue<Object>(ValueEnforcer.isGT0(n, "MaxQueueSize")));
    }

    public AbstractConcurrentCollector(@Nonnull BlockingQueue<Object> blockingQueue) {
        ValueEnforcer.notNull(blockingQueue, "Queue");
        this.m_aQueue = blockingQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public final ESuccess queueObject(@Nonnull DATATYPE DATATYPE) {
        ValueEnforcer.notNull(DATATYPE, "Object");
        if (this.isStopped()) {
            throw new IllegalStateException("The queue is already stopped and does not take any more elements");
        }
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aQueue.put(DATATYPE);
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (InterruptedException interruptedException) {
            s_aLogger.error("Failed to submit object to queue", (Throwable)interruptedException);
            ESuccess eSuccess = ESuccess.FAILURE;
            return eSuccess;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    @Override
    public boolean isQueueEmpty() {
        this.m_aRWLock.readLock().lock();
        try {
            boolean bl = this.m_aQueue.isEmpty();
            return bl;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Override
    @Nonnegative
    public final int getQueueLength() {
        this.m_aRWLock.readLock().lock();
        try {
            int n = this.m_aQueue.size();
            return n;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    @Override
    @Nonnull
    public final ESuccess stopQueuingNewObjects() {
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aQueue.put(STOP_QUEUE_OBJECT);
            this.m_bStopTakingNewObjects = true;
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (InterruptedException interruptedException) {
            s_aLogger.error("Error stopping queue", (Throwable)interruptedException);
            ESuccess eSuccess = ESuccess.FAILURE;
            return eSuccess;
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
    }

    @Override
    public final boolean isStopped() {
        this.m_aRWLock.readLock().lock();
        try {
            boolean bl = this.m_bStopTakingNewObjects;
            return bl;
        }
        finally {
            this.m_aRWLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    @ReturnsMutableCopy
    public final List<DATATYPE> drainQueue() {
        ArrayList arrayList = new ArrayList();
        this.m_aRWLock.writeLock().lock();
        try {
            this.m_aQueue.drainTo(arrayList);
        }
        finally {
            this.m_aRWLock.writeLock().unlock();
        }
        ArrayList arrayList2 = new ArrayList();
        for (Object e : arrayList) {
            if (e != STOP_QUEUE_OBJECT) {
                arrayList2.add(GenericReflection.uncheckedCast(e));
                continue;
            }
            this.m_aRWLock.writeLock().lock();
            try {
                this.m_aQueue.add(e);
            }
            finally {
                this.m_aRWLock.writeLock().unlock();
            }
        }
        return arrayList2;
    }
}

