/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.csv;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.csv.CSVReader;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;

public class CSVIterator
implements Iterator<List<String>> {
    private final CSVReader m_aReader;
    private List<String> m_aNextLine;

    public CSVIterator(@Nonnull CSVReader cSVReader) throws IOException {
        ValueEnforcer.notNull(cSVReader, "Reader");
        this.m_aReader = cSVReader;
        this.m_aNextLine = cSVReader.readNext();
    }

    @Override
    public boolean hasNext() {
        return this.m_aNextLine != null;
    }

    @Override
    @Nonnull
    public List<String> next() {
        List<String> list = this.m_aNextLine;
        try {
            this.m_aNextLine = this.m_aReader.readNext();
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to read next CSV line", iOException);
        }
        return list;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("This is a read-only CSV iterator.");
    }
}

