/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file.filter;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.file.filter.AbstractFileFilter;
import com.helger.commons.regex.RegExHelper;
import com.helger.commons.string.ToStringGenerator;
import java.io.File;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class FileFilterFilenameMatchAnyRegEx
extends AbstractFileFilter {
    private final String[] m_aRegExs;

    public FileFilterFilenameMatchAnyRegEx(@Nonnull @Nonempty String string) {
        this(new String[]{string});
    }

    public FileFilterFilenameMatchAnyRegEx(String ... stringArray) {
        ValueEnforcer.notEmpty(stringArray, "RegularExpressions");
        this.m_aRegExs = ArrayHelper.getCopy(stringArray);
    }

    @Nonnull
    @ReturnsMutableCopy
    public String[] getAllRegularExpressions() {
        return ArrayHelper.getCopy(this.m_aRegExs);
    }

    @Override
    public boolean matchesThisFilter(@Nullable File file) {
        String string;
        if (file != null && (string = FilenameHelper.getSecureFilename(file.getName())) != null) {
            for (String string2 : this.m_aRegExs) {
                if (!RegExHelper.stringMatchesPattern(string2, string)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        FileFilterFilenameMatchAnyRegEx fileFilterFilenameMatchAnyRegEx = (FileFilterFilenameMatchAnyRegEx)object;
        return Arrays.equals(this.m_aRegExs, fileFilterFilenameMatchAnyRegEx.m_aRegExs);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aRegExs).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("regExs", this.m_aRegExs).toString();
    }
}

