/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.microdom.util;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.microdom.AbstractMicroNode;
import com.helger.commons.microdom.IMicroContainer;
import com.helger.commons.microdom.IMicroDocument;
import com.helger.commons.microdom.IMicroElement;
import com.helger.commons.microdom.IMicroNode;
import com.helger.commons.microdom.MicroCDATA;
import com.helger.commons.microdom.MicroComment;
import com.helger.commons.microdom.MicroContainer;
import com.helger.commons.microdom.MicroDocument;
import com.helger.commons.microdom.MicroDocumentType;
import com.helger.commons.microdom.MicroElement;
import com.helger.commons.microdom.MicroEntityReference;
import com.helger.commons.microdom.MicroProcessingInstruction;
import com.helger.commons.microdom.MicroText;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;

@Immutable
public final class MicroHelper {
    private static final MicroHelper s_aInstance = new MicroHelper();

    private MicroHelper() {
    }

    @Nonnull
    public static IMicroNode append(@Nonnull IMicroNode iMicroNode, @Nullable Object object) {
        ValueEnforcer.notNull(iMicroNode, "SrcNode");
        if (object != null) {
            if (object instanceof IMicroNode) {
                iMicroNode.appendChild((IMicroNode)object);
            } else if (object instanceof String) {
                iMicroNode.appendText((String)object);
            } else if (object instanceof Iterable) {
                for (Object t : (Iterable)object) {
                    MicroHelper.append(iMicroNode, t);
                }
            } else if (ArrayHelper.isArray(object)) {
                for (Object object2 : (Object[])object) {
                    MicroHelper.append(iMicroNode, object2);
                }
            } else {
                throw new IllegalArgumentException("Passed object cannot be appended to an IMicroNode (type=" + object.getClass().getName() + ".");
            }
        }
        return iMicroNode;
    }

    @Nonnull
    @SuppressFBWarnings(value={"IL_INFINITE_LOOP"})
    public static String getPath(@Nullable IMicroNode iMicroNode, @Nonnull String string) {
        ValueEnforcer.notNull(string, "Separator");
        StringBuilder stringBuilder = new StringBuilder();
        for (IMicroNode iMicroNode2 = iMicroNode; iMicroNode2 != null; iMicroNode2 = iMicroNode2.getParent()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.insert(0, string);
            }
            stringBuilder.insert(0, iMicroNode2.getNodeName());
        }
        return stringBuilder.toString();
    }

    @Nullable
    public static String getDocumentRootElementTagName(@Nullable IMicroDocument iMicroDocument) {
        IMicroElement iMicroElement;
        if (iMicroDocument != null && (iMicroElement = iMicroDocument.getDocumentElement()) != null) {
            return iMicroElement.getTagName();
        }
        return null;
    }

    @Nonnull
    public static IMicroNode convertToMicroNode(@Nonnull Node node) {
        Object object;
        Object object2;
        AbstractMicroNode abstractMicroNode;
        ValueEnforcer.notNull(node, "Node");
        short s = node.getNodeType();
        switch (s) {
            case 9: {
                abstractMicroNode = new MicroDocument();
                break;
            }
            case 10: {
                object2 = (DocumentType)node;
                abstractMicroNode = new MicroDocumentType(object2.getName(), object2.getPublicId(), object2.getSystemId());
                break;
            }
            case 1: {
                object2 = (Element)node;
                String string = object2.getNamespaceURI();
                MicroElement microElement = string != null ? new MicroElement(string, object2.getLocalName()) : new MicroElement(object2.getTagName());
                object = node.getAttributes();
                if (object != null) {
                    int n = object.getLength();
                    for (int i = 0; i < n; ++i) {
                        Attr attr = (Attr)object.item(i);
                        String string2 = attr.getNamespaceURI();
                        if (string2 != null) {
                            if ("http://www.w3.org/2000/xmlns/".equals(string2)) continue;
                            microElement.setAttribute(string2, attr.getLocalName(), attr.getValue());
                            continue;
                        }
                        microElement.setAttribute(attr.getName(), attr.getValue());
                    }
                }
                abstractMicroNode = microElement;
                break;
            }
            case 4: {
                abstractMicroNode = new MicroCDATA(node.getNodeValue());
                break;
            }
            case 3: {
                abstractMicroNode = new MicroText(node.getNodeValue());
                break;
            }
            case 8: {
                abstractMicroNode = new MicroComment(node.getNodeValue());
                break;
            }
            case 5: {
                abstractMicroNode = new MicroEntityReference(node.getNodeValue());
                break;
            }
            case 7: {
                object2 = (ProcessingInstruction)node;
                abstractMicroNode = new MicroProcessingInstruction(object2.getTarget(), object2.getData());
                break;
            }
            case 2: {
                throw new IllegalArgumentException("Unknown/unsupported node type: ATTRIBUTE_NODE");
            }
            case 6: {
                throw new IllegalArgumentException("Unknown/unsupported node type: ENTITY_NODE");
            }
            case 11: {
                throw new IllegalArgumentException("Unknown/unsupported node type: DOCUMENT_FRAGMENT_NODE");
            }
            case 12: {
                throw new IllegalArgumentException("Unknown/unsupported node type: NOTATION_NODE");
            }
            default: {
                throw new IllegalArgumentException("Unknown/unsupported node type: " + s);
            }
        }
        object2 = node.getChildNodes();
        if (object2 != null) {
            int n = object2.getLength();
            for (int i = 0; i < n; ++i) {
                object = object2.item(i);
                abstractMicroNode.appendChild(MicroHelper.convertToMicroNode((Node)object));
            }
        }
        return abstractMicroNode;
    }

    @Nullable
    public static String getChildTextContent(@Nonnull IMicroElement iMicroElement, @Nonnull String string) {
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(string);
        return iMicroElement2 != null ? iMicroElement2.getTextContent() : null;
    }

    @Nullable
    public static String getChildTextContentTrimmed(@Nonnull IMicroElement iMicroElement, @Nonnull String string) {
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(string);
        return iMicroElement2 != null ? iMicroElement2.getTextContentTrimmed() : null;
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE getChildTextContentWithConversion(@Nonnull IMicroElement iMicroElement, @Nonnull String string, @Nonnull Class<DSTTYPE> clazz) {
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(string);
        return iMicroElement2 != null ? (DSTTYPE)iMicroElement2.getTextContentWithConversion(clazz) : null;
    }

    @Nullable
    public static String getChildTextContent(@Nonnull IMicroElement iMicroElement, @Nonnull String string, @Nonnull String string2) {
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(string, string2);
        return iMicroElement2 != null ? iMicroElement2.getTextContent() : null;
    }

    @Nullable
    public static String getChildTextContentTrimmed(@Nonnull IMicroElement iMicroElement, @Nonnull String string, @Nonnull String string2) {
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(string, string2);
        return iMicroElement2 != null ? iMicroElement2.getTextContentTrimmed() : null;
    }

    @Nullable
    public static <DSTTYPE> DSTTYPE getChildTextContentWithConversion(@Nonnull IMicroElement iMicroElement, @Nonnull String string, @Nonnull String string2, @Nonnull Class<DSTTYPE> clazz) {
        IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(string, string2);
        return iMicroElement2 != null ? (DSTTYPE)iMicroElement2.getTextContentWithConversion(clazz) : null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static IMicroContainer getAllChildrenAsContainer(@Nonnull IMicroNode iMicroNode) {
        MicroContainer microContainer = new MicroContainer();
        if (iMicroNode.hasChildren()) {
            for (IMicroNode iMicroNode2 : iMicroNode.getAllChildren()) {
                microContainer.appendChild((IMicroNode)iMicroNode2.getClone());
            }
        }
        return microContainer;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static IMicroContainer getAllOriginalChildrenAsContainer(@Nonnull IMicroNode iMicroNode) {
        MicroContainer microContainer = new MicroContainer();
        if (iMicroNode.hasChildren()) {
            for (IMicroNode iMicroNode2 : iMicroNode.getAllChildren()) {
                microContainer.appendChild(iMicroNode2.detachFromParent());
            }
        }
        return microContainer;
    }
}

