/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.statistics.util;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.microdom.IMicroElement;
import com.helger.commons.statistics.IStatisticsHandlerCache;
import com.helger.commons.statistics.IStatisticsHandlerCounter;
import com.helger.commons.statistics.IStatisticsHandlerKeyedCounter;
import com.helger.commons.statistics.IStatisticsHandlerKeyedSize;
import com.helger.commons.statistics.IStatisticsHandlerKeyedTimer;
import com.helger.commons.statistics.IStatisticsHandlerSize;
import com.helger.commons.statistics.IStatisticsHandlerTimer;
import com.helger.commons.statistics.util.DefaultStatisticsVisitorCallback;
import javax.annotation.Nonnull;

public class StatisticsVisitorCallbackToXML
extends DefaultStatisticsVisitorCallback {
    private final IMicroElement m_eRoot;

    public StatisticsVisitorCallbackToXML(@Nonnull IMicroElement iMicroElement) {
        this.m_eRoot = ValueEnforcer.notNull(iMicroElement, "Root");
    }

    @Nonnull
    public IMicroElement getRoot() {
        return this.m_eRoot;
    }

    @Override
    public void onCache(String string, IStatisticsHandlerCache iStatisticsHandlerCache) {
        if (iStatisticsHandlerCache.getInvocationCount() > 0) {
            this.m_eRoot.appendElement("cache").setAttribute("name", string).setAttribute("invocationcount", iStatisticsHandlerCache.getInvocationCount()).setAttribute("hits", iStatisticsHandlerCache.getHits()).setAttribute("misses", iStatisticsHandlerCache.getMisses());
        }
    }

    @Override
    public void onTimer(String string, IStatisticsHandlerTimer iStatisticsHandlerTimer) {
        if (iStatisticsHandlerTimer.getInvocationCount() > 0) {
            this.m_eRoot.appendElement("timer").setAttribute("name", string).setAttribute("invocationcount", iStatisticsHandlerTimer.getInvocationCount()).setAttribute("min", iStatisticsHandlerTimer.getMin()).setAttribute("average", iStatisticsHandlerTimer.getAverage()).setAttribute("max", iStatisticsHandlerTimer.getMax()).setAttributeWithConversion("sum", (Object)iStatisticsHandlerTimer.getSum());
        }
    }

    @Override
    public void onKeyedTimer(String string, IStatisticsHandlerKeyedTimer iStatisticsHandlerKeyedTimer) {
        if (iStatisticsHandlerKeyedTimer.getInvocationCount() > 0) {
            IMicroElement iMicroElement = this.m_eRoot.appendElement("keyedtimer").setAttribute("name", string).setAttribute("invocationcount", iStatisticsHandlerKeyedTimer.getInvocationCount());
            for (String string2 : CollectionHelper.getSorted(iStatisticsHandlerKeyedTimer.getAllKeys())) {
                iMicroElement.appendElement("key").setAttribute("name", string2).setAttribute("invocationcount", iStatisticsHandlerKeyedTimer.getInvocationCount(string2)).setAttribute("min", iStatisticsHandlerKeyedTimer.getMin(string2)).setAttribute("average", iStatisticsHandlerKeyedTimer.getAverage(string2)).setAttribute("max", iStatisticsHandlerKeyedTimer.getMax(string2)).setAttributeWithConversion("sum", (Object)iStatisticsHandlerKeyedTimer.getSum(string2));
            }
        }
    }

    @Override
    public void onSize(String string, IStatisticsHandlerSize iStatisticsHandlerSize) {
        if (iStatisticsHandlerSize.getInvocationCount() > 0) {
            this.m_eRoot.appendElement("size").setAttribute("name", string).setAttribute("invocationcount", iStatisticsHandlerSize.getInvocationCount()).setAttribute("min", iStatisticsHandlerSize.getMin()).setAttribute("average", iStatisticsHandlerSize.getAverage()).setAttribute("max", iStatisticsHandlerSize.getMax()).setAttributeWithConversion("sum", (Object)iStatisticsHandlerSize.getSum());
        }
    }

    @Override
    public void onKeyedSize(String string, IStatisticsHandlerKeyedSize iStatisticsHandlerKeyedSize) {
        if (iStatisticsHandlerKeyedSize.getInvocationCount() > 0) {
            IMicroElement iMicroElement = this.m_eRoot.appendElement("keyedsize").setAttribute("name", string).setAttribute("invocationcount", iStatisticsHandlerKeyedSize.getInvocationCount());
            for (String string2 : CollectionHelper.getSorted(iStatisticsHandlerKeyedSize.getAllKeys())) {
                iMicroElement.appendElement("key").setAttribute("name", string2).setAttribute("invocationcount", iStatisticsHandlerKeyedSize.getInvocationCount(string2)).setAttribute("min", iStatisticsHandlerKeyedSize.getMin(string2)).setAttribute("average", iStatisticsHandlerKeyedSize.getAverage(string2)).setAttribute("max", iStatisticsHandlerKeyedSize.getMax(string2)).setAttributeWithConversion("sum", (Object)iStatisticsHandlerKeyedSize.getSum(string2));
            }
        }
    }

    @Override
    public void onCounter(String string, IStatisticsHandlerCounter iStatisticsHandlerCounter) {
        if (iStatisticsHandlerCounter.getInvocationCount() > 0) {
            this.m_eRoot.appendElement("counter").setAttribute("name", string).setAttribute("invocationcount", iStatisticsHandlerCounter.getInvocationCount()).setAttribute("count", iStatisticsHandlerCounter.getCount());
        }
    }

    @Override
    public void onKeyedCounter(String string, IStatisticsHandlerKeyedCounter iStatisticsHandlerKeyedCounter) {
        if (iStatisticsHandlerKeyedCounter.getInvocationCount() > 0) {
            IMicroElement iMicroElement = this.m_eRoot.appendElement("keyedcounter").setAttribute("name", string).setAttribute("invocationcount", iStatisticsHandlerKeyedCounter.getInvocationCount());
            for (String string2 : CollectionHelper.getSorted(iStatisticsHandlerKeyedCounter.getAllKeys())) {
                iMicroElement.appendElement("key").setAttribute("name", string2).setAttribute("invocationcount", iStatisticsHandlerKeyedCounter.getInvocationCount(string2)).setAttribute("count", iStatisticsHandlerKeyedCounter.getCount(string2));
            }
        }
    }
}

