/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.tree;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.tree.ITree;
import com.helger.commons.tree.ITreeItem;
import com.helger.commons.tree.ITreeItemFactory;
import java.util.Collection;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class BasicTree<DATATYPE, ITEMTYPE extends ITreeItem<DATATYPE, ITEMTYPE>>
implements ITree<DATATYPE, ITEMTYPE> {
    private final ITEMTYPE m_aRootItem;

    public BasicTree(@Nonnull ITreeItemFactory<DATATYPE, ITEMTYPE> iTreeItemFactory) {
        ValueEnforcer.notNull(iTreeItemFactory, "Factory");
        this.m_aRootItem = iTreeItemFactory.createRoot();
        if (this.m_aRootItem == null) {
            throw new IllegalStateException("Failed to create root item!");
        }
    }

    @Override
    public final boolean hasChildren() {
        return true;
    }

    @Override
    @Nonnegative
    public int getChildCount() {
        return 1;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final Collection<? extends ITEMTYPE> getAllChildren() {
        return CollectionHelper.newList(this.m_aRootItem);
    }

    @Override
    @Nonnull
    public final ITEMTYPE getRootItem() {
        return this.m_aRootItem;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        BasicTree basicTree = (BasicTree)object;
        return this.m_aRootItem.equals(basicTree.m_aRootItem);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aRootItem).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("RootItem", this.m_aRootItem).toString();
    }
}

