/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.tree.withid.folder;

import com.helger.commons.aggregate.IAggregator;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.tree.withid.BasicTreeItemWithID;
import com.helger.commons.tree.withid.folder.IFolderTreeItem;
import com.helger.commons.tree.withid.folder.IFolderTreeItemFactory;
import java.util.ArrayList;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class BasicFolderTreeItem<KEYTYPE, DATATYPE, COLLTYPE extends Collection<DATATYPE>, ITEMTYPE extends BasicFolderTreeItem<KEYTYPE, DATATYPE, COLLTYPE, ITEMTYPE>>
extends BasicTreeItemWithID<KEYTYPE, COLLTYPE, ITEMTYPE>
implements IFolderTreeItem<KEYTYPE, DATATYPE, COLLTYPE, ITEMTYPE> {
    private final IAggregator<KEYTYPE, KEYTYPE> m_aKeyCombinator;

    public BasicFolderTreeItem(@Nonnull IFolderTreeItemFactory<KEYTYPE, DATATYPE, COLLTYPE, ITEMTYPE> iFolderTreeItemFactory) {
        super(iFolderTreeItemFactory);
        this.m_aKeyCombinator = iFolderTreeItemFactory.getKeyCombinator();
    }

    public BasicFolderTreeItem(@Nonnull IFolderTreeItemFactory<KEYTYPE, DATATYPE, COLLTYPE, ITEMTYPE> iFolderTreeItemFactory, @Nullable KEYTYPE KEYTYPE) {
        super(iFolderTreeItemFactory, KEYTYPE);
        this.m_aKeyCombinator = iFolderTreeItemFactory.getKeyCombinator();
    }

    public BasicFolderTreeItem(@Nonnull ITEMTYPE ITEMTYPE, @Nonnull KEYTYPE KEYTYPE) {
        super(ITEMTYPE, KEYTYPE);
        this.m_aKeyCombinator = ((BasicFolderTreeItem)ITEMTYPE).m_aKeyCombinator;
    }

    @Override
    @Nonnull
    public final KEYTYPE getGlobalUniqueDataID() {
        if (this.m_aKeyCombinator == null) {
            return this.getID();
        }
        BasicFolderTreeItem basicFolderTreeItem = (BasicFolderTreeItem)this.getParent();
        if (basicFolderTreeItem == null) {
            return this.getID();
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(basicFolderTreeItem.getGlobalUniqueDataID());
        arrayList.add(this.getID());
        return this.m_aKeyCombinator.aggregate(arrayList);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        BasicFolderTreeItem basicFolderTreeItem = (BasicFolderTreeItem)object;
        return EqualsHelper.equals(this.m_aKeyCombinator, basicFolderTreeItem.m_aKeyCombinator);
    }

    @Override
    public int hashCode() {
        return HashCodeGenerator.getDerived(super.hashCode()).append(this.m_aKeyCombinator).getHashCode();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("keyCombinator", this.m_aKeyCombinator).toString();
    }
}

