/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.sax;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.stream.NonBlockingStringReader;
import com.helger.commons.string.ToStringGenerator;
import java.io.Reader;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.xml.sax.InputSource;

public class StringSAXInputSource
extends InputSource {
    private final String m_sText;

    public StringSAXInputSource(@Nonnull char[] cArray) {
        this(new String(cArray));
    }

    public StringSAXInputSource(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2) {
        this(new String(cArray, n, n2));
    }

    public StringSAXInputSource(@Nonnull CharSequence charSequence) {
        this(charSequence instanceof String ? (String)charSequence : charSequence.toString());
    }

    public StringSAXInputSource(@Nonnull String string) {
        this(string, null);
    }

    public StringSAXInputSource(@Nonnull String string, @Nullable String string2) {
        this.m_sText = ValueEnforcer.notNull(string, "Text");
        this.setSystemId(string2);
    }

    @Nonnull
    public String getText() {
        return this.m_sText;
    }

    @Override
    public Reader getCharacterStream() {
        return new NonBlockingStringReader(this.m_sText);
    }

    public String toString() {
        return new ToStringGenerator(this).append("text", this.m_sText).append("systemID", this.getSystemId()).toString();
    }
}

