/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control;

import java.io.Serializable;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleScriptContext;
import org.apache.jmeter.control.GenericController;
import org.apache.jmeter.control.NextIsNullException;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.testelement.ThreadListener;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class IfController
extends GenericController
implements Serializable,
ThreadListener {
    private static final Logger logger = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 241L;
    private static final String NASHORN_ENGINE_NAME = "nashorn";
    private static final String CONDITION = "IfController.condition";
    private static final String EVALUATE_ALL = "IfController.evaluateAll";
    private static final String USE_EXPRESSION = "IfController.useExpression";
    private static final String USE_RHINO_ENGINE_PROPERTY = "javascript.use_rhino";
    private static final boolean USE_RHINO_ENGINE = JMeterUtils.getPropDefault("javascript.use_rhino", true) || IfController.getInstance().getEngineByName("nashorn") == null;
    private static final ThreadLocal<ScriptEngine> NASHORN_ENGINE = new ThreadLocal<ScriptEngine>(){

        @Override
        protected ScriptEngine initialValue() {
            return IfController.getInstance().getEngineByName(IfController.NASHORN_ENGINE_NAME);
        }
    };
    private static JsEvaluator JAVASCRIPT_EVALUATOR = USE_RHINO_ENGINE ? new RhinoJsEngine() : new NashornJsEngine();

    private static ScriptEngineManager getInstance() {
        return LazyHolder.INSTANCE;
    }

    public IfController() {
    }

    public IfController(String condition) {
        this.setCondition(condition);
    }

    public void setCondition(String condition) {
        this.setProperty(new StringProperty(CONDITION, condition));
    }

    public String getCondition() {
        return this.getPropertyAsString(CONDITION);
    }

    private boolean evaluateCondition(String cond) {
        if (logger.isDebugEnabled()) {
            logger.debug("    getCondition() : [" + cond + "]");
        }
        return JAVASCRIPT_EVALUATOR.evaluate(this.getName(), cond);
    }

    private static boolean computeResultFromString(String condition, String resultStr) throws Exception {
        boolean result;
        switch (resultStr) {
            case "false": {
                result = false;
                break;
            }
            case "true": {
                result = true;
                break;
            }
            default: {
                throw new Exception(" BAD CONDITION :: " + condition + " :: expected true or false");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("    >> evaluate Condition -  [ " + condition + "] results is  [" + result + "]");
        }
        return result;
    }

    private static boolean evaluateExpression(String cond) {
        return cond.equalsIgnoreCase("true");
    }

    @Override
    public boolean isDone() {
        return false;
    }

    @Override
    public Sampler next() {
        boolean result = true;
        if (this.isEvaluateAll() || this.isFirst()) {
            boolean bl = result = this.isUseExpression() ? IfController.evaluateExpression(this.getCondition()) : this.evaluateCondition(this.getCondition());
        }
        if (result) {
            return super.next();
        }
        try {
            this.initializeSubControllers();
            return this.nextIsNull();
        }
        catch (NextIsNullException e1) {
            return null;
        }
    }

    @Override
    public void triggerEndOfLoop() {
        super.initializeSubControllers();
        super.triggerEndOfLoop();
    }

    public boolean isEvaluateAll() {
        return this.getPropertyAsBoolean(EVALUATE_ALL, false);
    }

    public void setEvaluateAll(boolean b) {
        this.setProperty(EVALUATE_ALL, b);
    }

    public boolean isUseExpression() {
        return this.getPropertyAsBoolean(USE_EXPRESSION, false);
    }

    public void setUseExpression(boolean selected) {
        this.setProperty(USE_EXPRESSION, selected, false);
    }

    @Override
    public void threadStarted() {
    }

    @Override
    public void threadFinished() {
        NASHORN_ENGINE.remove();
    }

    private static class LazyHolder {
        public static final ScriptEngineManager INSTANCE = new ScriptEngineManager();

        private LazyHolder() {
        }
    }

    private static class NashornJsEngine
    implements JsEvaluator {
        private NashornJsEngine() {
        }

        @Override
        public boolean evaluate(String testElementName, String condition) {
            try {
                SimpleScriptContext newContext = new SimpleScriptContext();
                newContext.setBindings(((ScriptEngine)NASHORN_ENGINE.get()).createBindings(), 100);
                Object o = ((ScriptEngine)NASHORN_ENGINE.get()).eval(condition, (ScriptContext)newContext);
                return IfController.computeResultFromString(condition, o.toString());
            }
            catch (Exception ex) {
                logger.error(testElementName + ": error while processing " + "[" + condition + "]\n", (Throwable)ex);
                return false;
            }
        }
    }

    private static class RhinoJsEngine
    implements JsEvaluator {
        private RhinoJsEngine() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean evaluate(String testElementName, String condition) {
            boolean result = false;
            Context cx = Context.enter();
            try {
                Scriptable scope = cx.initStandardObjects(null);
                Object cxResultObject = cx.evaluateString(scope, condition, "<cmd>", 1, null);
                result = IfController.computeResultFromString(condition, Context.toString((Object)cxResultObject));
            }
            catch (Exception e) {
                logger.error(testElementName + ": error while processing " + "[" + condition + "]\n", (Throwable)e);
            }
            finally {
                Context.exit();
            }
            return result;
        }
    }

    private static interface JsEvaluator {
        public boolean evaluate(String var1, String var2);
    }
}

