/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.engine;

import java.util.Map;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.engine.util.ValueReplacer;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class PreCompiler
implements HashTreeTraverser {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final ValueReplacer replacer = new ValueReplacer();
    private final boolean isRemote;

    public PreCompiler() {
        this.isRemote = false;
    }

    public PreCompiler(boolean remote) {
        this.isRemote = remote;
    }

    public void addNode(Object node, HashTree subTree) {
        Map<String, String> args;
        if (this.isRemote && node instanceof ResultCollector) {
            try {
                this.replacer.replaceValues((TestElement)node);
            }
            catch (InvalidVariableException e) {
                log.error("invalid variables", (Throwable)e);
            }
        }
        if (this.isRemote) {
            return;
        }
        if (node instanceof TestElement) {
            try {
                this.replacer.replaceValues((TestElement)node);
            }
            catch (InvalidVariableException e) {
                log.error("invalid variables", (Throwable)e);
            }
        }
        if (node instanceof TestPlan) {
            ((TestPlan)node).prepareForPreCompile();
            args = ((TestPlan)node).getUserDefinedVariables();
            this.replacer.setUserDefinedVariables(args);
            JMeterVariables vars = new JMeterVariables();
            vars.putAll(args);
            JMeterContextService.getContext().setVariables(vars);
        }
        if (node instanceof Arguments) {
            ((Arguments)node).setRunningVersion(true);
            args = ((Arguments)node).getArgumentsAsMap();
            this.replacer.addVariables(args);
            JMeterContextService.getContext().getVariables().putAll(args);
        }
    }

    public void subtractNode() {
    }

    public void processPath() {
    }
}

