/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import org.apache.jmeter.samplers.SampleSaveConfiguration;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.reflect.Functor;
import org.apache.log.Logger;

public class SavePropertyDialog
extends JDialog
implements ActionListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 232L;
    private static final Map<String, Functor> functors = new HashMap<String, Functor>();
    private static final String RESOURCE_PREFIX = "save_";
    private SampleSaveConfiguration saveConfig;

    @Deprecated
    public SavePropertyDialog() {
        log.warn("Constructor only intended for use in testing");
    }

    public SavePropertyDialog(Frame owner, String title, boolean modal, SampleSaveConfiguration s) {
        super(owner, title, modal);
        this.saveConfig = s;
        log.debug("SampleSaveConfiguration = " + this.saveConfig);
        this.initDialog();
    }

    private void initDialog() {
        this.getContentPane().setLayout(new BorderLayout());
        int configCount = SampleSaveConfiguration.SAVE_CONFIG_NAMES.size() / 3 + 1;
        log.debug("grid panel is 3 by " + configCount);
        JPanel checkPanel = new JPanel(new GridLayout(configCount, 3));
        for (String name : SampleSaveConfiguration.SAVE_CONFIG_NAMES) {
            try {
                JCheckBox check = new JCheckBox(JMeterUtils.getResString(RESOURCE_PREFIX + name), this.getSaveState(SampleSaveConfiguration.getterName(name)));
                check.addActionListener(this);
                String actionCommand = SampleSaveConfiguration.setterName(name);
                check.setActionCommand(actionCommand);
                if (!functors.containsKey(actionCommand)) {
                    functors.put(actionCommand, new Functor(actionCommand));
                }
                checkPanel.add((Component)check, "North");
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                log.warn("Problem creating save config dialog", (Throwable)e);
            }
        }
        this.getContentPane().add((Component)checkPanel, "North");
        JButton exit = new JButton(JMeterUtils.getResString("done"));
        this.getContentPane().add((Component)exit, "South");
        exit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SavePropertyDialog.this.dispose();
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String action = e.getActionCommand();
        Functor f = functors.get(action);
        f.invoke((Object)this.saveConfig, new Object[]{((JCheckBox)e.getSource()).isSelected()});
    }

    private boolean getSaveState(String methodName) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = SampleSaveConfiguration.class.getMethod(methodName, new Class[0]);
        return (Boolean)method.invoke((Object)this.saveConfig, new Object[0]);
    }

    public SampleSaveConfiguration getSaveConfig() {
        return this.saveConfig;
    }

    public void setSaveConfig(SampleSaveConfiguration saveConfig) {
        this.saveConfig = saveConfig;
    }
}

