/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.action.Command;
import org.apache.jmeter.gui.util.EscapeDialog;
import org.apache.jmeter.swing.HtmlPane;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.ComponentUtil;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class Help
implements Command {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final Set<String> commands = new HashSet<String>();
    private static final String HELP_DOCS = "file:///" + JMeterUtils.getJMeterHome() + "/printable_docs/usermanual/";
    private static final String HELP_PAGE = HELP_DOCS + "component_reference.html";
    public static final String HELP_FUNCTIONS = HELP_DOCS + "functions.html";
    private static JDialog helpWindow;
    private static final HtmlPane helpDoc;
    private static final JScrollPane scroller;

    @Override
    public void doAction(ActionEvent e) {
        if (helpWindow == null) {
            helpWindow = new EscapeDialog(new Frame(), JMeterUtils.getResString("help"), false);
            helpWindow.getContentPane().setLayout(new GridLayout(1, 1));
            helpWindow.getContentPane().removeAll();
            helpWindow.getContentPane().add(scroller);
            ComponentUtil.centerComponentInWindow((Component)helpWindow, (int)60);
        }
        helpWindow.setVisible(true);
        StringBuilder url = new StringBuilder();
        if (e.getSource() instanceof String[]) {
            String[] source = (String[])e.getSource();
            url.append(source[0]).append('#').append(source[1]);
        } else {
            url.append(HELP_PAGE).append('#').append(GuiPackage.getInstance().getTreeListener().getCurrentNode().getDocAnchor());
        }
        try {
            helpDoc.setPage(url.toString());
        }
        catch (IOException ioe) {
            log.error(ioe.toString());
            helpDoc.setText("<html><head><title>Problem loading help page</title><style><!--.note { background-color: #ffeeee; border: 1px solid brown; }div { padding: 10; margin: 10; }--></style></head><body><div class='note'><h1>Problem loading help page</h1><div>Can't load url: &quot;<em>" + url.toString() + "</em>&quot;</div>" + "<div>See log for more info</div>" + "</body>");
        }
    }

    @Override
    public Set<String> getActionNames() {
        return commands;
    }

    static {
        commands.add("help");
        helpDoc = new HtmlPane();
        scroller = new JScrollPane(helpDoc);
        helpDoc.setEditable(false);
    }
}

