/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.gui.action.Searcher;

public class RawTextSearcher
implements Searcher {
    private boolean caseSensitive;
    private String textToSearch;

    public RawTextSearcher(boolean caseSensitive, String textToSearch) {
        this.caseSensitive = caseSensitive;
        this.textToSearch = caseSensitive ? textToSearch : textToSearch.toLowerCase();
    }

    @Override
    public boolean search(List<String> textTokens) {
        boolean result = false;
        for (String searchableToken : textTokens) {
            if (StringUtils.isEmpty((CharSequence)searchableToken) || !(result = this.caseSensitive ? searchableToken.contains(this.textToSearch) : searchableToken.toLowerCase().contains(this.textToSearch))) continue;
            return result;
        }
        return false;
    }

    protected boolean testField(String value, String searchedTextLowerCase) {
        if (!StringUtils.isEmpty((CharSequence)value)) {
            return value.toLowerCase().contains(searchedTextLowerCase);
        }
        return false;
    }
}

