/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.action;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.Searchable;
import org.apache.jmeter.gui.action.ActionRouter;
import org.apache.jmeter.gui.action.KeyStrokes;
import org.apache.jmeter.gui.action.RawTextSearcher;
import org.apache.jmeter.gui.action.RegexpSearcher;
import org.apache.jmeter.gui.action.Searcher;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.ComponentUtil;
import org.apache.jorphan.gui.JLabeledTextField;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class SearchTreeDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -4436834972710248247L;
    private static final Logger logger = LoggingManager.getLoggerForClass();
    private static final Font FONT_DEFAULT = UIManager.getDefaults().getFont("TextField.font");
    private static final Font FONT_SMALL = new Font("SansSerif", 0, (int)Math.round((double)FONT_DEFAULT.getSize() * 0.8));
    private JButton searchButton;
    private JLabeledTextField searchTF;
    private JCheckBox isRegexpCB;
    private JCheckBox isCaseSensitiveCB;
    private JButton cancelButton;
    private transient String lastSearch = null;
    private JButton searchAndExpandButton;

    public SearchTreeDialog() {
        super((Frame)null, JMeterUtils.getResString("search_tree_title"), true);
        this.init();
    }

    @Override
    protected JRootPane createRootPane() {
        JRootPane rootPane = new JRootPane();
        AbstractAction escapeAction = new AbstractAction("ESCAPE"){
            private static final long serialVersionUID = -6543764044868772971L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchTreeDialog.this.setVisible(false);
            }
        };
        AbstractAction enterAction = new AbstractAction("ENTER"){
            private static final long serialVersionUID = -3661361497864527363L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchTreeDialog.this.doSearch(actionEvent);
            }
        };
        ActionMap actionMap = rootPane.getActionMap();
        actionMap.put(escapeAction.getValue("Name"), escapeAction);
        actionMap.put(enterAction.getValue("Name"), enterAction);
        InputMap inputMap = rootPane.getInputMap(2);
        inputMap.put(KeyStrokes.ESC, escapeAction.getValue("Name"));
        inputMap.put(KeyStrokes.ENTER, enterAction.getValue("Name"));
        return rootPane;
    }

    private void init() {
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        this.searchTF = new JLabeledTextField(JMeterUtils.getResString("search_text_field"), 20);
        if (!StringUtils.isEmpty((CharSequence)this.lastSearch)) {
            this.searchTF.setText(this.lastSearch);
        }
        this.isRegexpCB = new JCheckBox(JMeterUtils.getResString("search_text_chkbox_regexp"), false);
        this.isCaseSensitiveCB = new JCheckBox(JMeterUtils.getResString("search_text_chkbox_case"), false);
        this.isRegexpCB.setFont(FONT_SMALL);
        this.isCaseSensitiveCB.setFont(FONT_SMALL);
        JPanel searchCriterionPanel = new JPanel(new FlowLayout(1));
        searchCriterionPanel.add(this.isCaseSensitiveCB);
        searchCriterionPanel.add(this.isRegexpCB);
        JPanel searchPanel = new JPanel();
        searchPanel.setLayout(new BoxLayout(searchPanel, 1));
        searchPanel.setBorder(BorderFactory.createEmptyBorder(7, 3, 3, 3));
        searchPanel.add((Component)this.searchTF, "North");
        searchPanel.add((Component)searchCriterionPanel, "Center");
        JPanel buttonsPanel = new JPanel(new FlowLayout(1));
        this.searchButton = new JButton(JMeterUtils.getResString("search"));
        this.searchButton.addActionListener(this);
        this.searchAndExpandButton = new JButton(JMeterUtils.getResString("search_expand"));
        this.searchAndExpandButton.addActionListener(this);
        this.cancelButton = new JButton(JMeterUtils.getResString("cancel"));
        this.cancelButton.addActionListener(this);
        buttonsPanel.add(this.searchButton);
        buttonsPanel.add(this.searchAndExpandButton);
        buttonsPanel.add(this.cancelButton);
        searchPanel.add((Component)buttonsPanel, "South");
        this.getContentPane().add(searchPanel);
        this.searchTF.requestFocusInWindow();
        this.pack();
        ComponentUtil.centerComponentInWindow((Component)this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cancelButton) {
            this.searchTF.requestFocusInWindow();
            this.setVisible(false);
            return;
        }
        this.doSearch(e);
    }

    private void doSearch(ActionEvent e) {
        boolean expand = e.getSource() == this.searchAndExpandButton;
        String wordToSearch = this.searchTF.getText();
        if (StringUtils.isEmpty((CharSequence)wordToSearch)) {
            return;
        }
        this.lastSearch = wordToSearch;
        ActionRouter.getInstance().doActionNow(new ActionEvent(e.getSource(), e.getID(), "search_reset"));
        Searcher searcher = null;
        searcher = this.isRegexpCB.isSelected() ? new RegexpSearcher(this.isCaseSensitiveCB.isSelected(), this.searchTF.getText()) : new RawTextSearcher(this.isCaseSensitiveCB.isSelected(), this.searchTF.getText());
        GuiPackage guiPackage = GuiPackage.getInstance();
        JMeterTreeModel jMeterTreeModel = guiPackage.getTreeModel();
        HashSet<JMeterTreeNode> nodes = new HashSet<JMeterTreeNode>();
        for (JMeterTreeNode jMeterTreeNode : jMeterTreeModel.getNodesOfType(Searchable.class)) {
            try {
                if (!(jMeterTreeNode.getUserObject() instanceof Searchable)) continue;
                Searchable searchable = (Searchable)jMeterTreeNode.getUserObject();
                List<JMeterTreeNode> matchingNodes = jMeterTreeNode.getPathToThreadGroup();
                List<String> searchableTokens = searchable.getSearchableTokens();
                boolean result = searcher.search(searchableTokens);
                if (!result) continue;
                nodes.addAll(matchingNodes);
            }
            catch (Exception ex) {
                logger.error("Error occured searching for word:" + wordToSearch, (Throwable)ex);
            }
        }
        GuiPackage guiInstance = GuiPackage.getInstance();
        JTree jTree = guiInstance.getMainFrame().getTree();
        for (JMeterTreeNode jMeterTreeNode : nodes) {
            jMeterTreeNode.setMarkedBySearch(true);
            if (!expand) continue;
            jTree.expandPath(new TreePath(jMeterTreeNode.getPath()));
        }
        GuiPackage.getInstance().getMainFrame().repaint();
        this.searchTF.requestFocusInWindow();
        this.setVisible(false);
    }
}

