/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui.util;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledField;

public class JLabeledRadioI18N
extends JPanel
implements JLabeledField,
ActionListener {
    private static final long serialVersionUID = 240L;
    private final JLabel mLabel = new JLabel();
    private final ButtonGroup bGroup = new ButtonGroup();
    private final ArrayList<ChangeListener> mChangeListeners = new ArrayList(3);

    public JLabeledRadioI18N(String label_resouce, String[] item_resources, String selectedItem) {
        this.setLabel(label_resouce);
        this.init(item_resources, selectedItem);
    }

    @Deprecated
    public JLabeledRadioI18N() {
    }

    private void init(String[] resouces, String selected) {
        this.add(this.mLabel);
        this.initButtonGroup(resouces, selected);
    }

    private void initButtonGroup(String[] resouces, String selected) {
        for (String resource : resouces) {
            JRadioButton btn = new JRadioButton(JMeterUtils.getResString(resource));
            btn.setActionCommand(resource);
            btn.addActionListener(this);
            this.bGroup.add(btn);
            this.add(btn);
            if (selected == null || !selected.equals(resource)) continue;
            btn.setSelected(true);
        }
    }

    public void resetButtons(String[] resouces, String selected) {
        Enumeration<AbstractButton> buttons = this.bGroup.getElements();
        ArrayList<AbstractButton> buttonsToRemove = new ArrayList<AbstractButton>(this.bGroup.getButtonCount());
        while (buttons.hasMoreElements()) {
            AbstractButton abstractButton = buttons.nextElement();
            buttonsToRemove.add(abstractButton);
        }
        for (AbstractButton abstractButton : buttonsToRemove) {
            abstractButton.removeActionListener(this);
            this.bGroup.remove(abstractButton);
        }
        for (AbstractButton abstractButton : buttonsToRemove) {
            this.remove(abstractButton);
        }
        this.initButtonGroup(resouces, selected);
    }

    public String getText() {
        return this.bGroup.getSelection().getActionCommand();
    }

    public void setText(String resourcename) {
        Enumeration<AbstractButton> en = this.bGroup.getElements();
        while (en.hasMoreElements()) {
            ButtonModel model = en.nextElement().getModel();
            if (model.getActionCommand().equals(resourcename)) {
                this.bGroup.setSelected(model, true);
                continue;
            }
            this.bGroup.setSelected(model, false);
        }
    }

    public final void setLabel(String label_resource) {
        this.mLabel.setText(JMeterUtils.getResString(label_resource));
    }

    public void addChangeListener(ChangeListener pChangeListener) {
        this.mChangeListeners.add(pChangeListener);
    }

    private void notifyChangeListeners() {
        ChangeEvent ce = new ChangeEvent(this);
        for (ChangeListener mChangeListener : this.mChangeListeners) {
            mChangeListener.stateChanged(ce);
        }
    }

    public List<JComponent> getComponentList() {
        LinkedList<JComponent> comps = new LinkedList<JComponent>();
        comps.add(this.mLabel);
        Enumeration<AbstractButton> en = this.bGroup.getElements();
        while (en.hasMoreElements()) {
            comps.add(en.nextElement());
        }
        return comps;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.notifyChangeListeners();
    }
}

