/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.core;

import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.report.core.ConvertException;
import org.apache.jmeter.report.core.Converters;
import org.apache.jmeter.report.core.SampleException;
import org.apache.jmeter.report.core.SampleMetadata;
import org.apache.jmeter.util.JMeterUtils;

public class Sample {
    private static final String ERROR_ON_SAMPLE = "Error in sample at line:";
    private static final String CONTROLLER_PATTERN = "Number of samples in transaction";
    private final boolean storesStartTimeStamp;
    private final SampleMetadata metadata;
    private final String[] data;
    private final long row;

    public Sample(long row, SampleMetadata metadata, String ... data) {
        this.row = row;
        this.metadata = metadata;
        this.data = data;
        this.storesStartTimeStamp = JMeterUtils.getPropDefault("sampleresult.timestamp.start", false);
    }

    public long getSampleRow() {
        return this.row;
    }

    public String getData(int index) {
        return this.data[index];
    }

    public String getData(String name) {
        return this.data[this.metadata.ensureIndexOf(name)];
    }

    public <TData> TData getData(Class<TData> clazz, int index, String fieldName) {
        try {
            return Converters.convert(clazz, this.data[index]);
        }
        catch (ConvertException ex) {
            throw new SampleException(ERROR_ON_SAMPLE + (this.row + 1L) + " converting field:" + fieldName + " at column:" + index + " to:" + clazz.getName() + ", fieldValue:'" + this.data[index] + "'", ex);
        }
    }

    public <TData> TData getData(Class<TData> clazz, String name) {
        return this.getData(clazz, this.metadata.ensureIndexOf(name), name);
    }

    public String toString() {
        return StringUtils.join((Object[])this.data, (char)this.metadata.getSeparator());
    }

    public long getTimestamp() {
        return this.getData(Long.TYPE, "timeStamp");
    }

    public long getElapsedTime() {
        return this.getData(Long.TYPE, "elapsed");
    }

    public long getStartTime() {
        return this.storesStartTimeStamp ? this.getTimestamp() : this.getTimestamp() - this.getElapsedTime();
    }

    public long getEndTime() {
        return this.storesStartTimeStamp ? this.getTimestamp() + this.getElapsedTime() : this.getTimestamp();
    }

    public String getResponseCode() {
        return this.getData("responseCode");
    }

    public String getFailureMessage() {
        return this.getData("failureMessage");
    }

    public String getName() {
        return this.getData("label");
    }

    public String getResponseMessage() {
        return this.getData("responseMessage");
    }

    public long getLatency() {
        return this.getData(Long.TYPE, "Latency");
    }

    public boolean getSuccess() {
        return this.getData(Boolean.TYPE, "success");
    }

    public int getSentBytes() {
        return this.getData(Integer.TYPE, "bytes");
    }

    public int getGroupThreads() {
        return this.getData(Integer.TYPE, "grpThreads");
    }

    public int getAllThreads() {
        return this.getData(Integer.TYPE, "allThreads");
    }

    public String getThreadName() {
        return this.getData("threadName");
    }

    public boolean isController() {
        String message = this.getResponseMessage();
        return message != null && message.startsWith(CONTROLLER_PATTERN);
    }
}

