/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor;

import org.apache.jmeter.report.core.Sample;
import org.apache.jmeter.report.processor.AbstractSummaryConsumer;
import org.apache.jmeter.report.processor.ApdexSummaryData;
import org.apache.jmeter.report.processor.ApdexThresholdsInfo;
import org.apache.jmeter.report.processor.ListResultData;
import org.apache.jmeter.report.processor.ThresholdSelector;
import org.apache.jmeter.report.processor.ValueResultData;
import org.apache.jmeter.util.JMeterUtils;

public class ApdexSummaryConsumer
extends AbstractSummaryConsumer<ApdexSummaryData> {
    private ThresholdSelector thresholdSelector;

    public final ThresholdSelector getThresholdSelector() {
        return this.thresholdSelector;
    }

    public final void setThresholdSelector(ThresholdSelector thresholdSelector) {
        this.thresholdSelector = thresholdSelector;
    }

    public ApdexSummaryConsumer() {
        super(true);
    }

    @Override
    protected ListResultData createDataResult(String key, ApdexSummaryData data) {
        ListResultData result = new ListResultData();
        result.addResult(new ValueResultData(this.getApdex(data)));
        ApdexThresholdsInfo thresholdsInfo = data.getApdexThresholdInfo();
        result.addResult(new ValueResultData(thresholdsInfo.getSatisfiedThreshold()));
        result.addResult(new ValueResultData(thresholdsInfo.getToleratedThreshold()));
        result.addResult(new ValueResultData(key != null ? key : JMeterUtils.getResString("reportgenerator_summary_total")));
        return result;
    }

    @Override
    protected String getKeyFromSample(Sample sample) {
        return sample.getName();
    }

    @Override
    protected void updateData(AbstractSummaryConsumer.SummaryInfo info, Sample sample) {
        ApdexSummaryData data;
        AbstractSummaryConsumer.SummaryInfo overallInfo = this.getOverallInfo();
        ApdexSummaryData overallData = (ApdexSummaryData)overallInfo.getData();
        if (overallData == null) {
            overallData = new ApdexSummaryData(this.getThresholdSelector().select(null));
            overallInfo.setData(overallData);
        }
        if ((data = (ApdexSummaryData)info.getData()) == null) {
            data = new ApdexSummaryData(this.getThresholdSelector().select(sample.getName()));
            info.setData(data);
        }
        data.incTotalCount();
        overallData.incTotalCount();
        if (sample.getSuccess()) {
            ApdexThresholdsInfo thresholdsInfo;
            long elapsedTime = sample.getElapsedTime();
            if (elapsedTime <= (thresholdsInfo = data.getApdexThresholdInfo()).getSatisfiedThreshold()) {
                data.incSatisfiedCount();
            } else if (elapsedTime <= thresholdsInfo.getToleratedThreshold()) {
                data.incToleratedCount();
            }
            ApdexThresholdsInfo overallThresholdsInfo = overallData.getApdexThresholdInfo();
            if (elapsedTime <= overallThresholdsInfo.getSatisfiedThreshold()) {
                overallData.incSatisfiedCount();
            } else if (elapsedTime <= overallThresholdsInfo.getToleratedThreshold()) {
                overallData.incToleratedCount();
            }
        }
    }

    private double getApdex(ApdexSummaryData data) {
        return ((double)data.getSatisfiedCount() + (double)data.getToleratedCount() / 2.0) / (double)data.getTotalCount();
    }

    @Override
    protected ListResultData createResultTitles() {
        ListResultData titles = new ListResultData();
        titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_summary_apdex_apdex")));
        titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_summary_apdex_satisfied")));
        titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_summary_apdex_tolerated")));
        titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_summary_apdex_samplers")));
        return titles;
    }
}

