/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor;

import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.report.core.Sample;
import org.apache.jmeter.report.processor.AbstractSummaryConsumer;
import org.apache.jmeter.report.processor.ListResultData;
import org.apache.jmeter.report.processor.ValueResultData;
import org.apache.jmeter.util.JMeterUtils;

public class ErrorsSummaryConsumer
extends AbstractSummaryConsumer<Long> {
    private static final boolean ASSERTION_RESULTS_FAILURE_MESSAGE = JMeterUtils.getPropDefault("jmeter.save.saveservice.assertion_results_failure_message", true);
    private static final Long ZERO = 0L;
    private static final String ASSERTION_FAILED = "Assertion failed";
    private long errorCount = 0L;

    public ErrorsSummaryConsumer() {
        super(false);
    }

    @Override
    protected ListResultData createDataResult(String key, Long data) {
        ListResultData result = new ListResultData();
        result.addResult(new ValueResultData(key != null ? key : JMeterUtils.getResString("reportgenerator_summary_total")));
        result.addResult(new ValueResultData(data));
        result.addResult(new ValueResultData((double)data.longValue() * 100.0 / (double)this.errorCount));
        result.addResult(new ValueResultData((double)data.longValue() * 100.0 / ((Long)this.getOverallInfo().getData()).doubleValue()));
        return result;
    }

    @Override
    protected String getKeyFromSample(Sample sample) {
        String code = sample.getResponseCode();
        if (this.isSuccessCode(code)) {
            String msg;
            code = ASSERTION_FAILED;
            if (ASSERTION_RESULTS_FAILURE_MESSAGE && !StringUtils.isEmpty((CharSequence)(msg = sample.getFailureMessage()))) {
                code = StringEscapeUtils.escapeJson((String)msg);
            }
        }
        return code;
    }

    @Override
    protected void updateData(AbstractSummaryConsumer.SummaryInfo info, Sample sample) {
        AbstractSummaryConsumer.SummaryInfo overallInfo = this.getOverallInfo();
        Long overallData = (Long)overallInfo.getData();
        if (overallData == null) {
            overallData = ZERO;
        }
        overallInfo.setData(overallData + 1L);
        if (!sample.getSuccess()) {
            ++this.errorCount;
            Long data = (Long)info.getData();
            if (data == null) {
                data = 1L;
            }
            info.setData(data + 1L);
        }
    }

    protected boolean isSuccessCode(String codeAsString) {
        if (StringUtils.isNumeric((CharSequence)codeAsString)) {
            try {
                int code = Integer.parseInt(codeAsString);
                return code >= 200 && code <= 399;
            }
            catch (NumberFormatException ex) {
                return false;
            }
        }
        return false;
    }

    @Override
    public void stopConsuming() {
        super.stopConsuming();
        this.errorCount = 0L;
    }

    @Override
    protected ListResultData createResultTitles() {
        ListResultData titles = new ListResultData();
        titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_summary_errors_type")));
        titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_summary_errors_count")));
        titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_summary_errors_rate_error")));
        titles.addResult(new ValueResultData(JMeterUtils.getResString("reportgenerator_summary_errors_rate_all")));
        return titles;
    }
}

