/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor;

import java.util.ArrayList;
import org.apache.jmeter.report.core.Sample;
import org.apache.jmeter.report.core.SampleBuilder;
import org.apache.jmeter.report.core.SampleMetadata;
import org.apache.jmeter.report.processor.AbstractSampleConsumer;
import org.apache.jmeter.report.processor.SampleIndexer;

public class TaggerConsumer<TIndex>
extends AbstractSampleConsumer {
    public static final String DEFAULT_TAG_LABEL = "Tag";
    private ArrayList<SampleBuilder> builders = new ArrayList();
    private SampleIndexer<TIndex> sampleIndexer;
    private String tagLabel = "Tag";

    public final String getTagLabel() {
        return this.tagLabel;
    }

    public final void setTagLabel(String tagLabel) {
        this.tagLabel = tagLabel;
    }

    public final SampleIndexer<TIndex> getSampleIndexer() {
        return this.sampleIndexer;
    }

    public final void setSampleIndexer(SampleIndexer<TIndex> sampleIndexer) {
        this.sampleIndexer = sampleIndexer;
    }

    private void initProducedMetadata() {
        this.builders.clear();
        int channelCount = this.getConsumedChannelCount();
        for (int i = 0; i < channelCount; ++i) {
            SampleMetadata consumedMetadata = this.getConsumedMetadata(i);
            int colCount = consumedMetadata.getColumnCount();
            String[] names = new String[colCount + 1];
            for (int j = 0; j < colCount; ++j) {
                names[j] = consumedMetadata.getColumnName(j);
            }
            names[colCount] = this.tagLabel;
            SampleMetadata producedMetadata = new SampleMetadata(consumedMetadata.getSeparator(), names);
            this.builders.add(new SampleBuilder(producedMetadata));
            super.setProducedMetadata(producedMetadata, i);
        }
    }

    private Sample createIndexedSample(Sample sample, int channel, TIndex index) {
        SampleBuilder builder = this.builders.get(channel);
        SampleMetadata metadata = builder.getMetadata();
        int colCount = metadata.getColumnCount();
        for (int i = 0; i < colCount - 1; ++i) {
            builder.add(sample.getData(i));
        }
        builder.add(String.valueOf(index));
        return builder.build();
    }

    @Override
    public void startConsuming() {
        if (this.sampleIndexer != null) {
            this.sampleIndexer.reset();
        }
        this.initProducedMetadata();
        super.startProducing();
    }

    @Override
    public void consume(Sample sample, int channel) {
        if (sample != null && this.sampleIndexer != null) {
            TIndex index = this.sampleIndexer.calculateIndex(sample);
            Sample indexedSample = this.createIndexedSample(sample, channel, index);
            super.produce(indexedSample, channel);
        }
    }

    @Override
    public void stopConsuming() {
        super.stopProducing();
    }
}

