/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor.graph.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.jmeter.report.core.Sample;
import org.apache.jmeter.report.processor.MeanAggregatorFactory;
import org.apache.jmeter.report.processor.graph.AbstractOverTimeGraphConsumer;
import org.apache.jmeter.report.processor.graph.AbstractSeriesSelector;
import org.apache.jmeter.report.processor.graph.GraphValueSelector;
import org.apache.jmeter.report.processor.graph.GroupInfo;
import org.apache.jmeter.report.processor.graph.TimeStampKeysSelector;

public class ActiveThreadsGraphConsumer
extends AbstractOverTimeGraphConsumer {
    @Override
    protected TimeStampKeysSelector createTimeStampKeysSelector() {
        TimeStampKeysSelector keysSelector = new TimeStampKeysSelector();
        keysSelector.setSelectBeginTime(false);
        return keysSelector;
    }

    @Override
    protected Map<String, GroupInfo> createGroupInfos() {
        HashMap<String, GroupInfo> groupInfos = new HashMap<String, GroupInfo>(1);
        groupInfos.put("Generic group", new GroupInfo(new MeanAggregatorFactory(), new AbstractSeriesSelector(){

            @Override
            public Iterable<String> select(Sample sample) {
                String threadName = sample.getThreadName();
                int index = threadName.lastIndexOf(" ");
                if (index >= 0) {
                    threadName = threadName.substring(0, index);
                }
                return Arrays.asList(threadName);
            }
        }, new GraphValueSelector(){

            @Override
            public double select(String series, Sample sample) {
                return sample.getGroupThreads();
            }
        }, false, false));
        return groupInfos;
    }
}

