/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.samplers;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.net.ConnectException;
import java.rmi.RemoteException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.jmeter.samplers.AbstractSampleSender;
import org.apache.jmeter.samplers.RemoteSampleListener;
import org.apache.jmeter.samplers.SampleEvent;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JMeterError;
import org.apache.log.Logger;

public class DiskStoreSampleSender
extends AbstractSampleSender
implements Serializable {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final long serialVersionUID = 252L;
    private final RemoteSampleListener listener;
    private volatile transient ObjectOutputStream oos;
    private volatile transient File temporaryFile;
    private volatile transient ExecutorService singleExecutor;

    @Deprecated
    public DiskStoreSampleSender() {
        log.warn("Constructor only intended for use in testing");
        this.listener = null;
    }

    DiskStoreSampleSender(RemoteSampleListener listener) {
        this.listener = listener;
        log.info("Using DiskStoreSampleSender for this test run");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void testEnded(String host) {
        log.info("Test Ended on " + host);
        this.singleExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    DiskStoreSampleSender.this.oos.close();
                }
                catch (IOException e) {
                    log.error("Failed to close data file ", (Throwable)e);
                }
            }
        });
        this.singleExecutor.shutdown();
        try {
            if (!this.singleExecutor.awaitTermination(3L, TimeUnit.SECONDS)) {
                log.error("Executor did not terminate in a timely fashion");
            }
        }
        catch (InterruptedException e1) {
            log.error("Executor did not terminate in a timely fashion", (Throwable)e1);
        }
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(this.temporaryFile));
            Object obj = null;
            while ((obj = ois.readObject()) != null) {
                if (obj instanceof SampleEvent) {
                    try {
                        this.listener.sampleOccurred((SampleEvent)obj);
                    }
                    catch (RemoteException err) {
                        if (err.getCause() instanceof ConnectException) {
                            throw new JMeterError("Could not return sample", (Throwable)err);
                        }
                        log.error("returning sample", (Throwable)err);
                    }
                    continue;
                }
                log.error("Unexpected object type found in data file " + obj.getClass().getName());
            }
        }
        catch (EOFException e) {
        }
        catch (IOException | ClassNotFoundException err) {
            log.error("returning sample", (Throwable)err);
        }
        finally {
            try {
                this.listener.testEnded(host);
            }
            catch (RemoteException e) {
                log.error("returning sample", (Throwable)e);
            }
            IOUtils.closeQuietly((InputStream)ois);
            if (!this.temporaryFile.delete()) {
                log.warn("Could not delete file:" + this.temporaryFile.getAbsolutePath());
            }
        }
    }

    @Override
    public void sampleOccurred(final SampleEvent e) {
        this.singleExecutor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    DiskStoreSampleSender.this.oos.writeObject(e);
                }
                catch (IOException err) {
                    log.error("sampleOccurred", (Throwable)err);
                }
            }
        });
    }

    private Object readResolve() throws ObjectStreamException {
        log.info("Using DiskStoreSampleSender for this test run");
        this.singleExecutor = Executors.newSingleThreadExecutor();
        try {
            this.temporaryFile = File.createTempFile("SerialisedSampleSender", ".ser");
            this.temporaryFile.deleteOnExit();
            this.singleExecutor.submit(new Runnable(){

                @Override
                public void run() {
                    try {
                        FileOutputStream anOutputStream = new FileOutputStream(DiskStoreSampleSender.this.temporaryFile);
                        DiskStoreSampleSender.this.oos = new ObjectOutputStream(anOutputStream);
                    }
                    catch (IOException e) {
                        log.error("Failed to create output Stream", (Throwable)e);
                    }
                }
            });
        }
        catch (IOException e) {
            log.error("Failed to create output file", (Throwable)e);
        }
        return this;
    }
}

