/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testelement.property;

import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.AbstractProperty;

public class ObjectProperty
extends AbstractProperty {
    private static final long serialVersionUID = 1L;
    private Object value;
    private Object savedValue;

    @Override
    public void recoverRunningVersion(TestElement owner) {
        if (this.savedValue != null) {
            this.value = this.savedValue;
        }
    }

    @Override
    public void setRunningVersion(boolean runningVersion) {
        super.setRunningVersion(runningVersion);
        this.savedValue = runningVersion ? this.value : null;
    }

    @Override
    public ObjectProperty clone() {
        ObjectProperty p = (ObjectProperty)super.clone();
        p.value = this.value;
        return p;
    }

    public ObjectProperty() {
    }

    public ObjectProperty(String name) {
        super(name);
    }

    public ObjectProperty(String name, Object p) {
        super(name);
        this.value = p;
    }

    @Override
    public String getStringValue() {
        return this.value.toString();
    }

    @Override
    public Object getObjectValue() {
        return this.value;
    }

    @Override
    public void setObjectValue(Object value) {
        this.value = value;
    }
}

