/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.collections.HashTreeTraverser;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class FindTestElementsUpToRootTraverser
implements HashTreeTraverser {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final LinkedList<TestElement> stack = new LinkedList();
    private final Object nodeToFind;
    private boolean stopRecording = false;

    public FindTestElementsUpToRootTraverser(Object nodeToFind) {
        this.nodeToFind = nodeToFind;
    }

    public void addNode(Object node, HashTree subTree) {
        if (this.stopRecording) {
            return;
        }
        if (node == this.nodeToFind) {
            this.stopRecording = true;
        }
        this.stack.addLast((TestElement)node);
    }

    public void subtractNode() {
        if (this.stopRecording) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Subtracting node, stack size = " + this.stack.size());
        }
        this.stack.removeLast();
    }

    public void processPath() {
    }

    public List<Controller> getControllersToRoot() {
        ArrayList<Controller> result = new ArrayList<Controller>(this.stack.size());
        LinkedList<TestElement> stackLocalCopy = new LinkedList<TestElement>(this.stack);
        while (!stackLocalCopy.isEmpty()) {
            TestElement te = stackLocalCopy.getLast();
            if (te instanceof Controller) {
                result.add((Controller)te);
            }
            stackLocalCopy.removeLast();
        }
        return result;
    }
}

