/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.mail.MessagingException;
import javax.mail.internet.AddressException;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.reporters.MailerModel;
import org.apache.jmeter.reporters.MailerResultCollector;
import org.apache.jmeter.reporters.ResultCollector;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class MailerVisualizer
extends AbstractVisualizer
implements ActionListener,
Clearable,
ChangeListener {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private JButton testerButton;
    private JTextField addressField;
    private JTextField fromField;
    private JTextField smtpHostField;
    private JTextField smtpPortField;
    private JTextField failureSubjectField;
    private JTextField successSubjectField;
    private JTextField failureField;
    private JTextField failureLimitField;
    private JTextField successLimitField;
    private JTextField smtpLoginField;
    private JTextField smtpPasswordField;
    private JComboBox<String> authTypeCombo;

    public MailerVisualizer() {
        this.setModel(new MailerResultCollector());
        this.initGui();
    }

    public JPanel getControlPanel() {
        return this;
    }

    public synchronized void clearData() {
        if (this.getModel() != null) {
            MailerModel model = ((MailerResultCollector)this.getModel()).getMailerModel();
            model.clear();
            this.updateVisualizer(model);
        }
    }

    public void add(final SampleResult res) {
        if (this.getModel() != null) {
            JMeterUtils.runSafe((boolean)false, (Runnable)new Runnable(){

                @Override
                public void run() {
                    MailerModel model = ((MailerResultCollector)MailerVisualizer.this.getModel()).getMailerModel();
                    model.add(res);
                    MailerVisualizer.this.updateVisualizer(model);
                }
            });
        }
    }

    public String toString() {
        return JMeterUtils.getResString((String)"mailer_string");
    }

    private void initGui() {
        this.setLayout(new BorderLayout());
        VerticalPanel mainPanel = new VerticalPanel();
        EmptyBorder margin = new EmptyBorder(5, 10, 5, 10);
        this.setBorder(margin);
        mainPanel.add(this.makeTitlePanel());
        VerticalPanel attributePane = new VerticalPanel();
        attributePane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"mailer_title_settings")));
        attributePane.add(this.createMailingSettings());
        attributePane.add(this.createSmtpSettings());
        JPanel testerPanel = new JPanel(new BorderLayout());
        this.testerButton = new JButton(JMeterUtils.getResString((String)"mailer_test_mail"));
        this.testerButton.addActionListener(this);
        this.testerButton.setEnabled(true);
        testerPanel.add((Component)this.testerButton, "East");
        attributePane.add(testerPanel);
        mainPanel.add((Component)attributePane);
        mainPanel.add(Box.createRigidArea(new Dimension(0, 5)));
        JPanel mailerPanel = new JPanel(new BorderLayout());
        mailerPanel.add((Component)new JLabel(JMeterUtils.getResString((String)"mailer_failures")), "West");
        this.failureField = new JTextField(6);
        this.failureField.setEditable(false);
        mailerPanel.add((Component)this.failureField, "Center");
        mainPanel.add(mailerPanel);
        this.add((Component)mainPanel, "Center");
    }

    private JPanel createMailingSettings() {
        JPanel settingsPane = new JPanel(new BorderLayout());
        settingsPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"mailer_title_message")));
        JPanel headerPane = new JPanel(new BorderLayout());
        headerPane.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        JPanel fromPane = new JPanel(new BorderLayout());
        fromPane.add((Component)new JLabel(JMeterUtils.getResString((String)"mailer_from")), "West");
        this.fromField = new JTextField(25);
        this.fromField.setEditable(true);
        fromPane.add((Component)this.fromField, "Center");
        fromPane.add(Box.createRigidArea(new Dimension(5, 0)), "East");
        headerPane.add((Component)fromPane, "West");
        JPanel addressPane = new JPanel(new BorderLayout());
        addressPane.add((Component)new JLabel(JMeterUtils.getResString((String)"mailer_addressees")), "West");
        this.addressField = new JTextField(10);
        this.addressField.setEditable(true);
        addressPane.add((Component)this.addressField, "Center");
        headerPane.add((Component)addressPane, "Center");
        JPanel successPane = new JPanel(new BorderLayout());
        successPane.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        JPanel succesSubjectPane = new JPanel(new BorderLayout());
        succesSubjectPane.add((Component)new JLabel(JMeterUtils.getResString((String)"mailer_success_subject")), "West");
        this.successSubjectField = new JTextField(10);
        this.successSubjectField.setEditable(true);
        succesSubjectPane.add((Component)this.successSubjectField, "Center");
        succesSubjectPane.add(Box.createRigidArea(new Dimension(5, 0)), "East");
        successPane.add((Component)succesSubjectPane, "Center");
        JPanel successLimitPane = new JPanel(new BorderLayout());
        successLimitPane.add((Component)new JLabel(JMeterUtils.getResString((String)"mailer_success_limit")), "West");
        this.successLimitField = new JTextField("2", 5);
        this.successLimitField.setEditable(true);
        successLimitPane.add((Component)this.successLimitField, "Center");
        successPane.add((Component)successLimitPane, "East");
        JPanel failurePane = new JPanel(new BorderLayout());
        failurePane.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        JPanel failureSubjectPane = new JPanel(new BorderLayout());
        failureSubjectPane.add((Component)new JLabel(JMeterUtils.getResString((String)"mailer_failure_subject")), "West");
        this.failureSubjectField = new JTextField(10);
        this.failureSubjectField.setEditable(true);
        failureSubjectPane.add((Component)this.failureSubjectField, "Center");
        failureSubjectPane.add(Box.createRigidArea(new Dimension(5, 0)), "East");
        failurePane.add((Component)failureSubjectPane, "Center");
        JPanel failureLimitPane = new JPanel(new BorderLayout());
        failureLimitPane.add((Component)new JLabel(JMeterUtils.getResString((String)"mailer_failure_limit")), "West");
        this.failureLimitField = new JTextField("2", 5);
        this.failureLimitField.setEditable(true);
        failureLimitPane.add((Component)this.failureLimitField, "Center");
        failurePane.add((Component)failureLimitPane, "East");
        settingsPane.add((Component)headerPane, "North");
        settingsPane.add((Component)successPane, "Center");
        settingsPane.add((Component)failurePane, "South");
        return settingsPane;
    }

    private JPanel createSmtpSettings() {
        JPanel settingsPane = new JPanel(new BorderLayout());
        settingsPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"mailer_title_smtpserver")));
        JPanel hostPane = new JPanel(new BorderLayout());
        hostPane.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        JPanel smtpHostPane = new JPanel(new BorderLayout());
        smtpHostPane.add((Component)new JLabel(JMeterUtils.getResString((String)"mailer_host")), "West");
        this.smtpHostField = new JTextField(10);
        this.smtpHostField.setEditable(true);
        smtpHostPane.add((Component)this.smtpHostField, "Center");
        smtpHostPane.add(Box.createRigidArea(new Dimension(5, 0)), "East");
        hostPane.add((Component)smtpHostPane, "Center");
        JPanel smtpPortPane = new JPanel(new BorderLayout());
        smtpPortPane.add((Component)new JLabel(JMeterUtils.getResString((String)"mailer_port")), "West");
        this.smtpPortField = new JTextField(10);
        this.smtpPortField.setEditable(true);
        smtpPortPane.add((Component)this.smtpPortField, "Center");
        hostPane.add((Component)smtpPortPane, "East");
        JPanel authPane = new JPanel(new BorderLayout());
        hostPane.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        JPanel smtpLoginPane = new JPanel(new BorderLayout());
        smtpLoginPane.add((Component)new JLabel(JMeterUtils.getResString((String)"mailer_login")), "West");
        this.smtpLoginField = new JTextField(10);
        this.smtpLoginField.setEditable(true);
        smtpLoginPane.add((Component)this.smtpLoginField, "Center");
        smtpLoginPane.add(Box.createRigidArea(new Dimension(5, 0)), "East");
        authPane.add((Component)smtpLoginPane, "Center");
        JPanel smtpPasswordPane = new JPanel(new BorderLayout());
        smtpPasswordPane.add((Component)new JLabel(JMeterUtils.getResString((String)"mailer_password")), "West");
        this.smtpPasswordField = new JPasswordField(10);
        this.smtpPasswordField.setEditable(true);
        smtpPasswordPane.add((Component)this.smtpPasswordField, "Center");
        smtpPasswordPane.add(Box.createRigidArea(new Dimension(5, 0)), "East");
        authPane.add((Component)smtpPasswordPane, "East");
        JPanel authTypePane = new JPanel(new BorderLayout());
        authTypePane.add((Component)new JLabel(JMeterUtils.getResString((String)"mailer_connection_security")), "West");
        this.authTypeCombo = new JComboBox<String>(new String[]{MailerModel.MailAuthType.NONE.toString(), MailerModel.MailAuthType.SSL.toString(), MailerModel.MailAuthType.TLS.toString()});
        this.authTypeCombo.setFont(new Font("SansSerif", 0, 10));
        authTypePane.add(this.authTypeCombo, "Center");
        JPanel credPane = new JPanel(new BorderLayout());
        credPane.add((Component)authPane, "Center");
        credPane.add((Component)authTypePane, "East");
        settingsPane.add((Component)hostPane, "North");
        settingsPane.add((Component)credPane, "Center");
        return settingsPane;
    }

    public String getLabelResource() {
        return "mailer_visualizer_title";
    }

    public String getAttributesTitle() {
        return JMeterUtils.getResString((String)"mailer_attributes_panel");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.testerButton) {
            ResultCollector testElement = this.getModel();
            this.modifyTestElement((TestElement)testElement);
            try {
                MailerModel model = ((MailerResultCollector)testElement).getMailerModel();
                model.sendTestMail();
                this.displayMessage(JMeterUtils.getResString((String)"mail_sent"), false);
            }
            catch (AddressException ex) {
                log.error("Invalid mail address ", (Throwable)ex);
                this.displayMessage(JMeterUtils.getResString((String)"invalid_mail_address") + "\n" + ex.getMessage(), true);
            }
            catch (MessagingException ex) {
                log.error("Couldn't send mail...", (Throwable)ex);
                this.displayMessage(JMeterUtils.getResString((String)"invalid_mail") + "\n" + ex.getMessage(), true);
            }
        }
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.updateVisualizer(((MailerResultCollector)el).getMailerModel());
    }

    public TestElement createTestElement() {
        ResultCollector model = this.getModel();
        if (model == null) {
            model = new MailerResultCollector();
            this.setModel(model);
        }
        this.modifyTestElement((TestElement)model);
        return model;
    }

    public void modifyTestElement(TestElement c) {
        super.modifyTestElement(c);
        MailerModel mailerModel = ((MailerResultCollector)c).getMailerModel();
        mailerModel.setFailureLimit(this.failureLimitField.getText());
        mailerModel.setFailureSubject(this.failureSubjectField.getText());
        mailerModel.setFromAddress(this.fromField.getText());
        mailerModel.setSmtpHost(this.smtpHostField.getText());
        mailerModel.setSmtpPort(this.smtpPortField.getText());
        mailerModel.setLogin(this.smtpLoginField.getText());
        mailerModel.setPassword(this.smtpPasswordField.getText());
        mailerModel.setMailAuthType(this.authTypeCombo.getSelectedItem().toString());
        mailerModel.setSuccessLimit(this.successLimitField.getText());
        mailerModel.setSuccessSubject(this.successSubjectField.getText());
        mailerModel.setToAddress(this.addressField.getText());
    }

    private void updateVisualizer(MailerModel model) {
        this.addressField.setText(model.getToAddress());
        this.fromField.setText(model.getFromAddress());
        this.smtpHostField.setText(model.getSmtpHost());
        this.smtpPortField.setText(model.getSmtpPort());
        this.smtpLoginField.setText(model.getLogin());
        this.smtpPasswordField.setText(model.getPassword());
        this.authTypeCombo.setSelectedItem(model.getMailAuthType().toString());
        this.successSubjectField.setText(model.getSuccessSubject());
        this.failureSubjectField.setText(model.getFailureSubject());
        this.failureLimitField.setText(String.valueOf(model.getFailureLimit()));
        this.failureField.setText(String.valueOf(model.getFailureCount()));
        this.successLimitField.setText(String.valueOf(model.getSuccessLimit()));
        this.repaint();
    }

    private void displayMessage(String message, boolean isError) {
        int type = 0;
        type = isError ? 0 : 1;
        JOptionPane.showMessageDialog(null, message, isError ? JMeterUtils.getResString((String)"mailer_msg_title_error") : JMeterUtils.getResString((String)"mailer_msg_title_information"), type);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof MailerModel) {
            MailerModel testModel = (MailerModel)e.getSource();
            this.updateVisualizer(testModel);
        } else {
            super.stateChanged(e);
        }
    }
}

