/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.gui.Searchable;
import org.apache.jmeter.gui.action.RawTextSearcher;
import org.apache.jmeter.gui.action.RegexpSearcher;
import org.apache.jmeter.gui.action.Searcher;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.SearchableTreeNode;
import org.apache.jorphan.gui.JLabeledTextField;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class SearchTreePanel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = -4436834972710248247L;
    private static final Logger LOG = LoggingManager.getLoggerForClass();
    private static final Font FONT_DEFAULT = UIManager.getDefaults().getFont("TextField.font");
    private static final Font FONT_SMALL = new Font("SansSerif", 0, (int)Math.round((double)FONT_DEFAULT.getSize() * 0.8));
    private JButton searchButton;
    private JLabeledTextField searchTF;
    private JCheckBox isRegexpCB;
    private JCheckBox isCaseSensitiveCB;
    private JButton resetButton;
    private DefaultMutableTreeNode defaultMutableTreeNode;

    public SearchTreePanel(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.init();
        this.defaultMutableTreeNode = defaultMutableTreeNode;
    }

    @Deprecated
    public SearchTreePanel() {
    }

    private void init() {
        this.setLayout(new BorderLayout(10, 10));
        this.searchTF = new JLabeledTextField(JMeterUtils.getResString((String)"search_text_field"), 20);
        this.isRegexpCB = new JCheckBox(JMeterUtils.getResString((String)"search_text_chkbox_regexp"), false);
        this.isCaseSensitiveCB = new JCheckBox(JMeterUtils.getResString((String)"search_text_chkbox_case"), false);
        this.isRegexpCB.setFont(FONT_SMALL);
        this.isCaseSensitiveCB.setFont(FONT_SMALL);
        this.searchButton = new JButton(JMeterUtils.getResString((String)"search"));
        this.searchButton.addActionListener(this);
        this.resetButton = new JButton(JMeterUtils.getResString((String)"reset"));
        this.resetButton.addActionListener(this);
        JPanel searchPanel = new JPanel(new FlowLayout(0));
        searchPanel.add((Component)this.searchTF);
        searchPanel.add(this.isCaseSensitiveCB);
        searchPanel.add(this.isRegexpCB);
        searchPanel.add(this.searchButton);
        searchPanel.add(this.resetButton);
        this.add(searchPanel);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.searchButton) {
            this.doSearch(e);
        } else if (e.getSource() == this.resetButton) {
            this.doResetSearch((SearchableTreeNode)this.defaultMutableTreeNode);
        }
    }

    private void doResetSearch(SearchableTreeNode searchableTreeNode) {
        searchableTreeNode.reset();
        searchableTreeNode.updateState();
        for (int i = 0; i < searchableTreeNode.getChildCount(); ++i) {
            this.doResetSearch((SearchableTreeNode)searchableTreeNode.getChildAt(i));
        }
    }

    private void doSearch(ActionEvent e) {
        String wordToSearch = this.searchTF.getText();
        if (StringUtils.isEmpty((CharSequence)wordToSearch)) {
            return;
        }
        Object searcher = null;
        searcher = this.isRegexpCB.isSelected() ? new RegexpSearcher(this.isCaseSensitiveCB.isSelected(), this.searchTF.getText()) : new RawTextSearcher(this.isCaseSensitiveCB.isSelected(), this.searchTF.getText());
        this.searchInNode((Searcher)searcher, (SearchableTreeNode)this.defaultMutableTreeNode);
    }

    private boolean searchInNode(Searcher searcher, SearchableTreeNode node) {
        node.reset();
        Object userObject = node.getUserObject();
        try {
            Searchable searchable = null;
            if (!(userObject instanceof Searchable)) {
                return false;
            }
            searchable = (Searchable)userObject;
            if (searcher.search(searchable.getSearchableTokens())) {
                node.setNodeHasMatched(true);
            }
            boolean foundInChildren = false;
            for (int i = 0; i < node.getChildCount(); ++i) {
                this.searchInNode(searcher, (SearchableTreeNode)node.getChildAt(i));
                foundInChildren = this.searchInNode(searcher, (SearchableTreeNode)node.getChildAt(i)) || foundInChildren;
            }
            if (!node.isNodeHasMatched()) {
                node.setChildrenNodesHaveMatched(foundInChildren);
            }
            node.updateState();
            return node.isNodeHasMatched() || node.isChildrenNodesHaveMatched();
        }
        catch (Exception e) {
            LOG.error("Error extracting data from tree node");
            return false;
        }
    }
}

