/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.mail.sampler;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.mail.URLName;
import org.apache.commons.io.IOUtils;
import org.apache.jmeter.protocol.mail.sampler.MailFileMessage;

public class MailFileFolder
extends Folder {
    private static final String FILENAME_FORMAT = "%d.msg";
    private static final String FILENAME_REGEX = "\\d+\\.msg";
    private boolean isOpen;
    private final File folderPath;
    private final boolean isFile;
    private static final FilenameFilter FILENAME_FILTER = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return name.matches(MailFileFolder.FILENAME_REGEX);
        }
    };

    public MailFileFolder(Store store, String path) {
        super(store);
        String base = store.getURLName().getHost();
        File parentFolder = new File(base);
        this.isFile = parentFolder.isFile();
        this.folderPath = this.isFile ? new File(base) : new File(base, path);
    }

    public MailFileFolder(Store store, URLName path) {
        this(store, path.getFile());
    }

    public void appendMessages(Message[] messages) throws MessagingException {
        throw new MessagingException("Not supported");
    }

    public void close(boolean expunge) throws MessagingException {
        this.store.close();
        this.isOpen = false;
    }

    public boolean create(int type) throws MessagingException {
        return false;
    }

    public boolean delete(boolean recurse) throws MessagingException {
        return false;
    }

    public boolean exists() throws MessagingException {
        return true;
    }

    public Message[] expunge() throws MessagingException {
        return new Message[0];
    }

    public Folder getFolder(String name) throws MessagingException {
        return this;
    }

    public String getFullName() {
        return this.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message getMessage(int index) throws MessagingException {
        MailFileMessage mailFileMessage;
        File f = this.isFile ? this.folderPath : new File(this.folderPath, String.format(FILENAME_FORMAT, index));
        BufferedInputStream fis = new BufferedInputStream(new FileInputStream(f));
        try {
            MailFileMessage m;
            mailFileMessage = m = new MailFileMessage(this, fis, index);
        }
        catch (Throwable throwable) {
            try {
                IOUtils.closeQuietly((InputStream)fis);
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new MessagingException("Cannot open folder: " + e.getMessage(), (Exception)e);
            }
        }
        IOUtils.closeQuietly((InputStream)fis);
        return mailFileMessage;
    }

    public int getMessageCount() throws MessagingException {
        if (!this.isOpen) {
            return -1;
        }
        if (this.isFile) {
            return 1;
        }
        File[] listFiles = this.folderPath.listFiles(FILENAME_FILTER);
        return listFiles != null ? listFiles.length : 0;
    }

    public String getName() {
        return this.toString();
    }

    public Folder getParent() throws MessagingException {
        return null;
    }

    public Flags getPermanentFlags() {
        return null;
    }

    public char getSeparator() throws MessagingException {
        return '/';
    }

    public int getType() throws MessagingException {
        return 1;
    }

    public boolean hasNewMessages() throws MessagingException {
        return false;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public Folder[] list(String pattern) throws MessagingException {
        return new Folder[]{this};
    }

    public void open(int mode) throws MessagingException {
        if (mode != 1) {
            throw new MessagingException("Implementation only supports read-only access");
        }
        this.mode = mode;
        this.isOpen = true;
    }

    public boolean renameTo(Folder newName) throws MessagingException {
        return false;
    }
}

