/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.functions;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.jmeter.engine.util.CompoundVariable;
import org.apache.jmeter.functions.AbstractFunction;
import org.apache.jmeter.functions.InvalidVariableException;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;

public class TimeFunction
extends AbstractFunction {
    private static final String KEY = "__time";
    private static final List<String> desc = new LinkedList<String>();
    private static final Map<String, String> aliases = new HashMap<String, String>();
    private String format = "";
    private String variable = "";

    public String execute(SampleResult previousResult, Sampler currentSampler) throws InvalidVariableException {
        JMeterVariables vars;
        String datetime;
        if (this.format.length() == 0) {
            datetime = Long.toString(System.currentTimeMillis());
        } else {
            String fmt = aliases.get(this.format);
            if (fmt == null) {
                fmt = this.format;
            }
            if (fmt.matches("/\\d+")) {
                long div = Long.parseLong(fmt.substring(1));
                datetime = Long.toString(System.currentTimeMillis() / div);
            } else {
                SimpleDateFormat df = new SimpleDateFormat(fmt);
                datetime = df.format(new Date());
            }
        }
        if (this.variable.length() > 0 && (vars = this.getVariables()) != null) {
            vars.put(this.variable, datetime);
        }
        return datetime;
    }

    public void setParameters(Collection<CompoundVariable> parameters) throws InvalidVariableException {
        this.checkParameterCount(parameters, 0, 2);
        Object[] values = parameters.toArray();
        int count = values.length;
        if (count > 0) {
            this.format = ((CompoundVariable)values[0]).execute();
        }
        if (count > 1) {
            this.variable = ((CompoundVariable)values[1]).execute().trim();
        }
    }

    public String getReferenceKey() {
        return KEY;
    }

    public List<String> getArgumentDesc() {
        return desc;
    }

    static {
        desc.add(JMeterUtils.getResString((String)"time_format"));
        desc.add(JMeterUtils.getResString((String)"function_name_paropt"));
        aliases.put("YMD", JMeterUtils.getPropDefault((String)"time.YMD", (String)"yyyyMMdd"));
        aliases.put("HMS", JMeterUtils.getPropDefault((String)"time.HMS", (String)"HHmmss"));
        aliases.put("YMDHMS", JMeterUtils.getPropDefault((String)"time.YMDHMS", (String)"yyyyMMdd-HHmmss"));
        aliases.put("USER1", JMeterUtils.getPropDefault((String)"time.USER1", (String)""));
        aliases.put("USER2", JMeterUtils.getPropDefault((String)"time.USER2", (String)""));
    }
}

