#!/usr/bin/env python
'''
Created on Aug 13, 2014

@author: ebracox
'''
import os

import SSHClient

class EnableSSHGoodies(object):
	'''
	classdocs
	'''
	
	def __init__(self, host, port=22, username="cms", password="cms1234"):
		'''
		Constructor
		'''
		self.client = SSHClient.SSHClient(host, port, username, password)
	
	def su(self, username, password):
		self.client.su(username, password)
	
	def setSSHDConfigs(self, sshd_config="/etc/ssh/sshd_config"):
		self.client.send("sed -i -e 's/^#GSSAPIAuthentication no/GSSAPIAuthentication no/g' %s" % sshd_config)
		self.client.send("sed -i -e 's/^GSSAPIAuthentication yes/#GSSAPIAuthentication yes/g' %s" % sshd_config)
		self.client.send("sed -i -e 's/^#UseDNS yes/UseDNS no/g' %s" % sshd_config)
		self.client.send("sed -i -e 's/^AllowUsers cms$/AllowUsers cms root/g' %s" % sshd_config)
	
	def addKey(self, keyFile=""):
		if not keyFile:
			keyFile = os.path.join(os.getenv("HOME"), ".ssh", "id_rsa.pub")
		if not os.path.exists(keyFile):
			print "Cannot copy ssh key..."
			print "File '%s' does not exist." % keyFile
			return
		key = file(keyFile, "r").read().strip()
		self.client.send("grep \"%s\" ~/.ssh/authorized_keys >/dev/null 2>&1 || echo \"%s\" >> ~/.ssh/authorized_keys" % (key, key))
	
	def restartService(self, service="sshd"):
		self.client.send("service %s restart" % service)
	
	def setTimezone(self, timezone="America/Los_Angeles"):
		self.client.send("sed -i 's|America/New_York|%s|' /etc/sysconfig/clock" % timezone)
		self.client.send("ln -sf /usr/share/zoneinfo/%s /etc/localtime" % timezone)
	
	def setNTP(self, ntpHost="10.116.49.86"):
		self.client.send("date")
		self.client.send("sed -i 's/SYNC_HWCLOCK=.*$/SYNC_HWCLOCK=yes/' /etc/sysconfig/ntpdate")
		self.client.send("sed -i 's/2.rhel.pool.ntp.org/%s/' /etc/ntp.conf" % ntpHost)
		self.client.send("service ntpd stop")
		self.client.send("ntpdate %s" % ntpHost)
		self.client.send("service ntpd start")
		self.client.send("chkconfig ntpd on")
		self.client.send("chkconfig ntpdate on")
	
	def setHostname(self):
		self.client.send('hostname $(grep -oP "HOSTNAME=\K.+" /etc/sysconfig/network)')
	
	def logout(self):
		self.client.logout()
	
def main(host):
	s = EnableSSHGoodies(host)
	s.su("root", "root1234")
	s.setSSHDConfigs()
	s.addKey()
	#s.setTimezone()
	#s.setNTP()
	#s.setHostname()
	s.restartService()
	s.logout()
	print

if __name__ == "__main__":
	import sys
	main(sys.argv[1])
