#!/usr/bin/env python
'''
Created on Aug 13, 2014

@author: ebracox
'''
import os
import paramiko
import re
import select
import socket #@UnusedImport
import sys

class SSHClient(object):
	'''
	classdocs
	'''


	def __init__(self, host, port=22, username="cms", password="cms1234"):
		'''
		Constructor
		'''
		
		self.getClient()
		
		self.setRoot(False)
		
		print "*** Connecting..."
		
		self.authenticate(host, port, username, password)
		self.getHostKey(host)
		self.channel = self.client.invoke_shell()
		
		self.channel.settimeout(1.0)
		self.channel.set_combine_stderr(True)
		self.flush()

	def getHostKey(self, host, hostKeyFile=""):
		if not hostKeyFile:
			hostKeyFile = os.path.join(os.getenv("HOME"), ".ssh", "known_hosts")
		if not os.path.exists(hostKeyFile):
			print "File '%s' does not exist." % hostKeyFile
			return False

		sh = self.client._system_host_keys.lookup(host)
		if sh:
			return sh.values()[0]
		
		h = self.client._host_keys.lookup(host)
		if h:
			print "Host '%s' is not stored in %s... adding now." % (host, hostKeyFile)
			self.client._system_host_keys.add(host, h.keys()[0], h.values()[0])
			self.client._system_host_keys.save(hostKeyFile)
			return h.values()[0]

		return None

	def getClient(self):
		self.client = paramiko.SSHClient()
		self.client.load_system_host_keys()
		self.client.set_missing_host_key_policy(paramiko.AutoAddPolicy())
	
	def authenticate(self, host, port, username, password, recurse=True):
		try:
			self.client.connect(host, port, username, password)
		except paramiko.BadHostKeyException, e:
			print e
			self.removeHost(host)
			if recurse:
				self.authenticate(host, port, username, password, recurse=False)
		except paramiko.AuthenticationException, e:
			self.client.connect(host, port, "root", "root1234")
			self.setRoot(True)
	
	def su(self, user="", password="root1234"):
		self.send("su - %s" % user)
		if password:
			if not self.isRoot():
				self.send(password)
	
	def isRoot(self):
		return self.root
	
	def setRoot(self, isRoot=True):
		self.root = isRoot
	
	def flush(self, inputs=[]):
		#self.channel.recv_ready()
		#for x in xrange(10000):
			#print "Waiting"
			#read, write, error = select.select([self.channel], [], [], 0.0)
			#if len(read) > 0:
			#sys.stdout.write(self.channel.recv(1024))
		
		while 1:
			try:
				#resp = self.channel.in_buffer.read(1024, .1)
				resp = self.channel.recv(1024)
				sys.stdout.write(resp.replace(" \r", ""))
				sys.stdout.flush()
			except paramiko.buffered_pipe.PipeTimeout:
				break
			except socket.timeout:
				break
	
	def send(self, command, inputs=[], addLF=True):
		# Give the time to breathe 
		for x in xrange(10000000): pass
		
		self.channel.send(command + ["", "\n"][addLF])
		self.flush()
		self.flush()
		
	def logout(self):
		self.send("exit;")
		self.channel.close()
		self.client.close()
	
	def removeHost(self, host, hostKeyFile=""):
		if not hostKeyFile:
			hostKeyFile = os.path.join(os.getenv("HOME"), ".ssh", "known_hosts")
		if not os.path.exists(hostKeyFile):
			print "Cannot remove host key..."
			print "File '%s' does not exist." % hostKeyFile
			return False
		print "Removing host '%s' from file '%s'..." % (host, hostKeyFile)
		
		try:
			fin = file(hostKeyFile, "r").read()
			matches = re.findall("%s ssh.*" % host, fin)
			if len(matches) != 1:
				print "Found %s matches..." % len(matches)
				print "\n".join(matches)
				return False
			else:
				f = fin.replace("%s\n" % matches[0], "")
				fout = file(hostKeyFile, "w")
				fout.write(f)
				fout.close()
				"Successfully removed host key."
				return True
		except Exception, e:
			print e
			print "Could not remove host key."
		finally:
			self.getClient()

def test():
	try:
		s = SSHClient("10.116.5.229")
		s.su()
		s.send("pwd")
	except Exception, e:
		print e
	finally:
		try:
			s.logout()
		except Exception, e:
			print e
			
if __name__ == "__main__":
	test()
