/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.snmp;

import com.ericsson.snmp.UsmUserInfo;
import org.snmp4j.PDU;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.UserTarget;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.security.AuthMD5;
import org.snmp4j.security.AuthSHA;
import org.snmp4j.security.Priv3DES;
import org.snmp4j.security.PrivAES128;
import org.snmp4j.security.PrivAES192;
import org.snmp4j.security.PrivAES256;
import org.snmp4j.security.PrivDES;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityModels;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.security.UsmUser;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class V3TrapSender {
    private static final String ERR_ENGINE = "Invalid engine ID: ";
    private static final String ERR_ENGINE_INFO = ". Expected hexadecimal string, such as '0102D30405AAB3'.";
    private Snmp snmp;
    private UserTarget target;

    public V3TrapSender() throws Exception {
        SecurityProtocols.getInstance().addPrivacyProtocol((PrivacyProtocol)new Priv3DES());
        SecurityProtocols.getInstance().addPrivacyProtocol((PrivacyProtocol)new PrivAES192());
        SecurityProtocols.getInstance().addPrivacyProtocol((PrivacyProtocol)new PrivAES256());
        DefaultUdpTransportMapping defaultUdpTransportMapping = new DefaultUdpTransportMapping();
        this.snmp = new Snmp((TransportMapping)defaultUdpTransportMapping);
        USM uSM = new USM();
        SecurityModels.getInstance().addSecurityModel((SecurityModel)uSM);
    }

    public void setLocalEngineId(String string, int n) {
        byte[] byArray = this.parseEngineId(string);
        this.snmp.setLocalEngine(byArray, n, 0);
    }

    private byte[] parseEngineId(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Engine ID is null.");
        }
        int n = string.length();
        if (n % 2 != 0) {
            throw new IllegalArgumentException(ERR_ENGINE + string + ERR_ENGINE_INFO);
        }
        for (int i = 0; i < n; ++i) {
            if (Character.digit(string.charAt(i), 16) >= 0) continue;
            throw new IllegalArgumentException(ERR_ENGINE + string + ERR_ENGINE_INFO);
        }
        try {
            return V3TrapSender.hexStringToByteArray(string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(ERR_ENGINE + string + ERR_ENGINE_INFO);
        }
    }

    private static byte[] hexStringToByteArray(String string) {
        int n = string.length();
        byte[] byArray = new byte[n / 2];
        for (int i = 0; i < n; i += 2) {
            byArray[i / 2] = (byte)((Character.digit(string.charAt(i), 16) << 4) + Character.digit(string.charAt(i + 1), 16));
        }
        return byArray;
    }

    private UsmUserInfo createUserInfo(String string, String string2, String string3) {
        UsmUserInfo usmUserInfo = new UsmUserInfo();
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("User could not be blank.");
        }
        usmUserInfo.userName = new OctetString(string);
        if ("MD5".equalsIgnoreCase(string2)) {
            usmUserInfo.authProtocol = AuthMD5.ID;
        } else if ("SHA".equalsIgnoreCase(string2)) {
            usmUserInfo.authProtocol = AuthSHA.ID;
        } else {
            throw new IllegalArgumentException("Invalid authentication protocol: " + string2 + ". Supported values: MD5 or SHA");
        }
        if (string3 == null || string3.isEmpty()) {
            throw new IllegalArgumentException("Authentication password could not be blank.");
        }
        usmUserInfo.authPassword = new OctetString(string3);
        return usmUserInfo;
    }

    private void addPrivacyInfo(UsmUserInfo usmUserInfo, String string, String string2) {
        if ("DES".equalsIgnoreCase(string)) {
            usmUserInfo.privProtocol = PrivDES.ID;
        } else if ("3DES".equalsIgnoreCase(string)) {
            usmUserInfo.privProtocol = Priv3DES.ID;
        } else if ("AES".equalsIgnoreCase(string) || "AES128".equalsIgnoreCase(string)) {
            usmUserInfo.privProtocol = PrivAES128.ID;
        } else if ("AES192".equalsIgnoreCase(string)) {
            usmUserInfo.privProtocol = PrivAES192.ID;
        } else if ("AES256".equalsIgnoreCase(string)) {
            usmUserInfo.privProtocol = PrivAES256.ID;
        } else {
            throw new IllegalArgumentException("Invalid encryption protocol: " + string + ". Supported values: DES, 3DES, AES (AES128), AES192, AES256");
        }
        if (string2 == null || string2.isEmpty()) {
            throw new IllegalArgumentException("Encryption password could not be blank.");
        }
        usmUserInfo.privPassword = new OctetString(string2);
    }

    public void addUser(String string) {
        if (string == null || string.isEmpty()) {
            throw new IllegalArgumentException("User could not be blank.");
        }
        OctetString octetString = new OctetString(string);
        UsmUser usmUser = new UsmUser(octetString, null, null, null, null);
        this.snmp.getUSM().addUser(octetString, usmUser);
    }

    public void addUser(String string, String string2, String string3) {
        UsmUserInfo usmUserInfo = this.createUserInfo(string, string2, string3);
        UsmUser usmUser = new UsmUser(usmUserInfo.userName, usmUserInfo.authProtocol, usmUserInfo.authPassword, null, null);
        this.snmp.getUSM().addUser(usmUserInfo.userName, usmUser);
    }

    public void addUser(String string, String string2, String string3, String string4, String string5) {
        UsmUserInfo usmUserInfo = this.createUserInfo(string, string2, string3);
        this.addPrivacyInfo(usmUserInfo, string4, string5);
        UsmUser usmUser = new UsmUser(usmUserInfo.userName, usmUserInfo.authProtocol, usmUserInfo.authPassword, usmUserInfo.privProtocol, usmUserInfo.privPassword);
        this.snmp.getUSM().addUser(usmUserInfo.userName, usmUser);
    }

    public void setTarget(String string, int n, String string2, String string3) {
        String string4 = "udp:" + string + "/" + n;
        Address address = GenericAddress.parse((String)string4);
        this.target = new UserTarget();
        this.target.setAddress(address);
        this.target.setRetries(1);
        this.target.setTimeout(11500L);
        this.target.setVersion(3);
        int n2 = 0;
        if ("authPriv".equalsIgnoreCase(string3)) {
            n2 = 3;
        } else if ("authNoPriv".equalsIgnoreCase(string3)) {
            n2 = 2;
        } else if ("noAuthNoPriv".equalsIgnoreCase(string3)) {
            n2 = 1;
        } else {
            throw new IllegalArgumentException("Invalid security level. Supported values: noAuthNoPriv, authNoPriv, authPriv");
        }
        this.target.setSecurityLevel(n2);
        this.target.setSecurityName(new OctetString(string2));
    }

    public void close() {
        try {
            this.snmp.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void send(long l, String string, String string2, String string3) throws Exception {
        ScopedPDU scopedPDU = new ScopedPDU();
        scopedPDU.setType(-89);
        scopedPDU.add(new VariableBinding(SnmpConstants.sysUpTime, (Variable)new TimeTicks(l)));
        scopedPDU.add(new VariableBinding(SnmpConstants.snmpTrapOID, (Variable)new OID(string)));
        scopedPDU.add(new VariableBinding(new OID(string2), (Variable)new OctetString(string3)));
        this.snmp.send((PDU)scopedPDU, (Target)this.target);
    }
}

