/*
 * Decompiled with CFR 0.152.
 */
package com.mediakind.contentapi.module.title.model.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.mediakind.contentapi.module.title.model.dto.Filter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

@Schema
public class AssetFilter {
    private Filters filters = new Filters();
    private List<Sort> sorts;
    private Pagination pagination = new Pagination();
    @Schema(description="The value should be \"full\" or \"summary\". Setting to \"full\" returns all info of an asset; \"summary\" returns the necessary fields for the asset list table to display.", example="summary")
    private String detail;
    @Schema(description="The keyword to search field quickSearch in Elasticsearch.")
    private String keyword;

    public Filters getFilters() {
        return this.filters;
    }

    public List<Sort> getSorts() {
        return this.sorts;
    }

    public Pagination getPagination() {
        return this.pagination;
    }

    public String getDetail() {
        return this.detail;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setFilters(Filters filters) {
        this.filters = filters;
    }

    public void setSorts(List<Sort> sorts) {
        this.sorts = sorts;
    }

    public void setPagination(Pagination pagination) {
        this.pagination = pagination;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssetFilter)) {
            return false;
        }
        AssetFilter other = (AssetFilter)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Filters this$filters = this.getFilters();
        Filters other$filters = other.getFilters();
        if (this$filters == null ? other$filters != null : !this$filters.equals(other$filters)) {
            return false;
        }
        List<Sort> this$sorts = this.getSorts();
        List<Sort> other$sorts = other.getSorts();
        if (this$sorts == null ? other$sorts != null : !((Object)this$sorts).equals(other$sorts)) {
            return false;
        }
        Pagination this$pagination = this.getPagination();
        Pagination other$pagination = other.getPagination();
        if (this$pagination == null ? other$pagination != null : !this$pagination.equals(other$pagination)) {
            return false;
        }
        String this$detail = this.getDetail();
        String other$detail = other.getDetail();
        if (this$detail == null ? other$detail != null : !this$detail.equals(other$detail)) {
            return false;
        }
        String this$keyword = this.getKeyword();
        String other$keyword = other.getKeyword();
        return !(this$keyword == null ? other$keyword != null : !this$keyword.equals(other$keyword));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AssetFilter;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Filters $filters = this.getFilters();
        result = result * 59 + ($filters == null ? 43 : $filters.hashCode());
        List<Sort> $sorts = this.getSorts();
        result = result * 59 + ($sorts == null ? 43 : ((Object)$sorts).hashCode());
        Pagination $pagination = this.getPagination();
        result = result * 59 + ($pagination == null ? 43 : $pagination.hashCode());
        String $detail = this.getDetail();
        result = result * 59 + ($detail == null ? 43 : $detail.hashCode());
        String $keyword = this.getKeyword();
        result = result * 59 + ($keyword == null ? 43 : $keyword.hashCode());
        return result;
    }

    public String toString() {
        return "AssetFilter(filters=" + this.getFilters() + ", sorts=" + this.getSorts() + ", pagination=" + this.getPagination() + ", detail=" + this.getDetail() + ", keyword=" + this.getKeyword() + ")";
    }

    public class Filters {
        @JsonProperty(value="and")
        @Schema(description="<p>The filter conditions for the list returned joined with AND. Supported field types and operators are as follows.</p><ul><li>date, time, integer, long, float: EQUAL, LESSTHAN, GREATERTHAN, LESSTHANEQUAL, GREATERTHANEQUAL, NOTEQUAL, IN, NOTIN</li><li>string: EQUAL, NOTEQUAL, IN, NOTIN, CONTAINS, MATCHES</li><li>list: IN, NOTIN</li><p><strong>Note</strong>: When \"field\" is Date type, the date format is \"yyyy-MM-dd\".</p>")
        private List<Filter> andFilter;
        @JsonProperty(value="or")
        @Schema(description="The filter conditions for the list returned joined with OR. Supports the same field types and operators with andFilter. <br/>If andFilter and orFilter are both specified, the orFilter conditions are grouped together to join with andFilter with an AND.")
        private List<Filter> orFilter;

        public List<Filter> getAndFilter() {
            return this.andFilter;
        }

        public List<Filter> getOrFilter() {
            return this.orFilter;
        }

        public void setAndFilter(List<Filter> andFilter) {
            this.andFilter = andFilter;
        }

        public void setOrFilter(List<Filter> orFilter) {
            this.orFilter = orFilter;
        }
    }

    public class Pagination {
        @Schema(defaultValue="0", description="Specifies the list entry after which the returned list starts.", example="0")
        private String start;
        @Schema(defaultValue="10", description="The number of objects to return in the response. The maximum value is 100. <br/><strong>Note</strong>: When the detail parameter is \"full\", the maximum value is 10.", example="10")
        private String size;

        public String getStart() {
            return this.start;
        }

        public void setStart(String start) {
            this.start = start;
        }

        public void setSize(String size) {
            this.size = size;
        }

        public String getSize() {
            return this.size;
        }
    }

    public static class Sort {
        @JsonProperty(value="sort_by")
        @Schema(description="The field name to sort by.", example="id")
        private String sortBy;
        @Schema(description="<p>The order of the sorted field. Should be one of the following:</p><ul><li>ASC: Ascending order.</li> <li>DESC: Descending order</li></ul><p><strong>Note</strong>: ASC means ascending order. DESC means descending order.</p>", example="DESC")
        private String order;

        public void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        public void setOrder(String order) {
            this.order = order;
        }

        public String getOrder() {
            return this.order;
        }

        public String getSortBy() {
            return this.sortBy;
        }
    }
}

