/*
 * Decompiled with CFR 0.152.
 */
package com.mediakind.contentapi.module.title.service.impl;

import com.mediakind.contentapi.annotation.IsMultipleField;
import com.mediakind.contentapi.exp.UnsupportFieldOrOperatorException;
import com.mediakind.contentapi.module.title.mapper.TitleMapper;
import com.mediakind.contentapi.module.title.model.dto.AssetFilter;
import com.mediakind.contentapi.module.title.model.entity.AssetProperty;
import com.mediakind.contentapi.module.title.model.entity.TitleDbEntity;
import com.mediakind.contentapi.module.title.model.entity.TitleEsEntity;
import com.mediakind.contentapi.module.title.model.enumeration.AssetStatus;
import com.mediakind.contentapi.module.title.model.vo.AssetFullVo;
import com.mediakind.contentapi.module.title.model.vo.AssetSummaryVo;
import com.mediakind.contentapi.module.title.model.vo.ImageVo;
import com.mediakind.contentapi.module.title.service.intf.IAssetService;
import com.mediakind.contentapi.module.title.service.intf.IElasticSearchService;
import com.mediakind.contentapi.module.title.util.TitleXmlParse;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dom4j.DocumentException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AssetServiceImpl
implements IAssetService {
    private static final Logger log = LogManager.getLogger(AssetServiceImpl.class);
    @Autowired
    IElasticSearchService elasticSearchService;
    @Autowired
    TitleMapper titleMapper;
    private List<Field> multipleFieldsList;

    @Override
    public Map<String, Object> listAssets(AssetFilter assetFilter) throws DocumentException, UnsupportFieldOrOperatorException, IllegalAccessException {
        String detail = assetFilter.getDetail();
        Map<String, Object> objectMap = this.elasticSearchService.searchTitle(assetFilter);
        List esEntities = (List)objectMap.get("esEntity");
        List<AssetSummaryVo> assetSummaryVos = this.titleEntitiesToVos(esEntities, detail);
        objectMap.put("assetsList", assetSummaryVos);
        return objectMap;
    }

    @Override
    public List<AssetProperty> getAssetThumbnailOfTitle(Integer titleId) {
        return this.titleMapper.getAssetProperty(titleId);
    }

    private List<AssetSummaryVo> titleEntitiesToVos(List<TitleEsEntity> esEntities, String detail) throws DocumentException, UnsupportFieldOrOperatorException, IllegalAccessException {
        ArrayList<AssetSummaryVo> assetSummaryVos = new ArrayList<AssetSummaryVo>();
        for (TitleEsEntity esEntity : esEntities) {
            AssetSummaryVo assetVo;
            this.multipleFieldsHandler(esEntity);
            List<AssetProperty> assetThumbnailOfTitle = this.getAssetThumbnailOfTitle(esEntity.getId());
            if ("summary".equalsIgnoreCase(detail)) {
                assetVo = new AssetSummaryVo(esEntity.getId(), esEntity.getName(), this.aggregateStatus(esEntity), esEntity.getProvider(), esEntity.getDescription(), esEntity.getRuntime(), (List)esEntity.getGenre(), (List)esEntity.getRating(), (List)esEntity.getLanguage(), esEntity.getLastModifiedTime(), esEntity.getCreateDate(), esEntity.getLicenseWindowStart(), esEntity.getLicenseWindowEnd(), "", "");
            } else if ("full".equalsIgnoreCase(detail)) {
                TitleDbEntity titleDbEntity = this.titleMapper.getTitleById(esEntity.getId());
                assetVo = new AssetFullVo(esEntity.getId(), esEntity.getName(), this.aggregateStatus(esEntity), esEntity.getProvider(), esEntity.getDescription(), esEntity.getRuntime(), (List)esEntity.getGenre(), (List)esEntity.getRating(), (List)esEntity.getLanguage(), esEntity.getLastModifiedTime(), esEntity.getCreateDate(), esEntity.getLicenseWindowStart(), esEntity.getLicenseWindowEnd(), "", "");
                TitleXmlParse.parseImagesAndVideosFromTitleXml((AssetFullVo)assetVo, titleDbEntity.getMdmDoc());
                block1: for (AssetProperty assetProperty : assetThumbnailOfTitle) {
                    for (ImageVo image : ((AssetFullVo)assetVo).getImages()) {
                        if (!assetProperty.getAssetId().equals(image.getId())) continue;
                        image.setThumbnailPath(assetProperty.getValue());
                        continue block1;
                    }
                }
            } else {
                throw new UnsupportFieldOrOperatorException(String.format("Do not support the Detail type:[%s]", detail));
            }
            if (!assetThumbnailOfTitle.isEmpty()) {
                assetVo.setThumbnailPath(this.getLatestThumbnailPathForFirstAsset(assetThumbnailOfTitle));
            }
            assetSummaryVos.add(assetVo);
        }
        return assetSummaryVos;
    }

    private String aggregateStatus(TitleEsEntity esEntity) throws UnsupportFieldOrOperatorException {
        String distributionStatus = esEntity.getDistributionStatus();
        String proccessStatus = esEntity.getProcessingStatus();
        String titleStatus = esEntity.getStatus();
        String aggregateStatus = null;
        aggregateStatus = distributionStatus != null && !"NONE".equals(distributionStatus) ? AssetStatus.getValue("Distribution " + distributionStatus) : (proccessStatus != null && !"NONE".equals(proccessStatus) ? AssetStatus.getValue("Title Processing " + proccessStatus) : AssetStatus.getValue("Title " + titleStatus));
        if (aggregateStatus == null) {
            throw new UnsupportFieldOrOperatorException(String.format("Can not find the status:[%s] in asset enumeration", aggregateStatus));
        }
        return aggregateStatus;
    }

    private void multipleFieldsHandler(TitleEsEntity titleEsEntity) throws IllegalAccessException {
        if (this.multipleFieldsList == null) {
            Field[] fields;
            this.multipleFieldsList = new ArrayList<Field>();
            for (Field field : fields = titleEsEntity.getClass().getDeclaredFields()) {
                boolean isMultipleField = field.isAnnotationPresent(IsMultipleField.class);
                if (!isMultipleField) continue;
                this.multipleFieldsList.add(field);
            }
        }
        for (Field field : this.multipleFieldsList) {
            field.setAccessible(true);
            Object value = field.get(titleEsEntity);
            if (!(value instanceof String)) continue;
            field.set(titleEsEntity, Collections.singletonList(value.toString()));
        }
    }

    private String getLatestThumbnailPathForFirstAsset(List<AssetProperty> assetThumbnailOfTitle) {
        Comparator comparator = (o1, o2) -> {
            long updateDate2;
            int assetId2;
            int assetId1 = o1.getAssetId();
            if (assetId1 != (assetId2 = o2.getAssetId().intValue())) {
                return assetId1 - assetId2;
            }
            long updateDate1 = o1.getUpdateDate().getTime();
            if (updateDate1 != (updateDate2 = o2.getUpdateDate().getTime())) {
                long l = updateDate2 - updateDate1;
                return (int)l;
            }
            return 0;
        };
        return ((AssetProperty)assetThumbnailOfTitle.stream().sorted(comparator).collect(Collectors.toList()).get(0)).getValue();
    }
}

