/*
 * Decompiled with CFR 0.152.
 */
package com.mediakind.contentapi.module.title.util;

import com.mediakind.contentapi.exp.MappingFileParserException;
import com.mediakind.contentapi.exp.UnsupportFieldOrOperatorException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DataTypeMappingReader {
    ConcurrentMap<String, List<String>> dataTypeMap;
    private static final String MAPPING_DELIMITER = ",";

    public DataTypeMappingReader(String dataTypeMappingFile) {
        this.dataTypeMap = this.readFieldMapping(dataTypeMappingFile);
    }

    public ConcurrentMap<String, List<String>> readFieldMapping(String mappingResource) {
        ConcurrentHashMap<String, List<String>> mappings = new ConcurrentHashMap<String, List<String>>();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(DataTypeMappingReader.class.getClassLoader().getResourceAsStream(mappingResource)));){
            String line;
            while ((line = br.readLine()) != null) {
                this.readInputStream(mappings, line);
            }
        }
        catch (IOException e) {
            throw new MappingFileParserException(e);
        }
        return mappings;
    }

    private void readInputStream(Map<String, List<String>> mappings, String line) {
        if (line.startsWith("#") || !line.contains(MAPPING_DELIMITER)) {
            return;
        }
        String[] fieldMapping = line.split(MAPPING_DELIMITER);
        ArrayList<String> list = new ArrayList<String>();
        list.add(fieldMapping[1].trim());
        list.add(fieldMapping[2].trim());
        mappings.put(fieldMapping[0].trim(), list);
    }

    public String getDataType(String inputField) throws UnsupportFieldOrOperatorException {
        List list = (List)this.dataTypeMap.get(inputField);
        if (list == null) {
            throw new UnsupportFieldOrOperatorException(String.format("Can not support field:[%s]", inputField));
        }
        return (String)list.get(1);
    }

    public String getEsEntityFieldName(String inputField) throws UnsupportFieldOrOperatorException {
        List list = (List)this.dataTypeMap.get(inputField);
        if (list == null) {
            throw new UnsupportFieldOrOperatorException(String.format("Can not support field:[%s]", inputField));
        }
        return (String)list.get(0);
    }
}

