/*
 * Decompiled with CFR 0.152.
 */
package com.mediakind.contentapi.advice;

import com.ericsson.neptune.security.filter.AuthenticationException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mediakind.contentapi.enumeration.ResultCode;
import com.mediakind.contentapi.enumeration.StatusCode;
import com.mediakind.contentapi.exp.UnsupportFieldOrOperatorException;
import com.mediakind.contentapi.vo.ResultVo;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

@RestControllerAdvice(basePackages={"com.mediakind.contentapi.module.title.controller"})
public class ControllerGlobalAdvice
implements ResponseBodyAdvice<Object> {
    private static final Logger log = LogManager.getLogger(ControllerGlobalAdvice.class);

    public boolean supports(MethodParameter methodParameter, Class<? extends HttpMessageConverter<?>> converterType) {
        return !methodParameter.getParameterType().isAssignableFrom(ResultVo.class);
    }

    public Object beforeBodyWrite(Object data, MethodParameter returnType, MediaType mediaType, Class<? extends HttpMessageConverter<?>> selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (returnType.getGenericParameterType().equals(String.class)) {
            ObjectMapper objectMapper = new ObjectMapper();
            return objectMapper.writeValueAsString(data);
        }
        return new ResultVo(data);
    }

    @ExceptionHandler(value={UnsupportFieldOrOperatorException.class})
    @ResponseBody
    public ResultVo exceptionHandler(HttpServletResponse httpServletResponse, UnsupportFieldOrOperatorException e) {
        log.error(e.getMessage(), (Throwable)e);
        httpServletResponse.setStatus(ResultCode.BAD_REQUEST.getCode());
        return new ResultVo((StatusCode)ResultCode.BAD_REQUEST, (Object)e.getMessage());
    }

    @ExceptionHandler(value={AuthenticationException.class})
    @ResponseBody
    public ResultVo exceptionHandler(HttpServletResponse httpServletResponse, AuthenticationException e) {
        log.error(e.getMessage(), (Throwable)e);
        httpServletResponse.setStatus(ResultCode.UNAUTHORIZED.getCode());
        return new ResultVo((StatusCode)ResultCode.UNAUTHORIZED, (Object)e.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    @ResponseBody
    public ResultVo exceptionHandler(HttpServletResponse httpServletResponse, Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        httpServletResponse.setStatus(ResultCode.INTERNAL_SERVER_ERROR.getCode());
        return new ResultVo((StatusCode)ResultCode.INTERNAL_SERVER_ERROR, (Object)e.getMessage());
    }
}

