/*
 * Decompiled with CFR 0.152.
 */
package com.mediakind.contentapi.config;

import com.ericsson.neptune.security.filter.TrustedSSLClientFilter;
import com.ericsson.neptune.security.filter.WebServicesAuthenticationFilter;
import javax.servlet.Filter;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class WebComponentConfig {
    @Bean
    public FilterRegistrationBean sslFilterRegister() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter(this.trustedSSLClientFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("TrustedSSLClientFilter");
        registration.addInitParameter("exclude_url", "api-docs");
        return registration;
    }

    @Bean
    public FilterRegistrationBean authorizationRegister() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter(this.webServicesAuthenticationFilter());
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setName("WebServicesAuthenticationFilter");
        registration.addInitParameter("exclude_url", "api-docs");
        registration.addInitParameter("Neptune", "true");
        registration.addInitParameter("neptune_sso_oauth2_provider_urls_properties", "/opt/tandbergtv/cms/conf/neptune/provider_urls.properties");
        return registration;
    }

    public Filter trustedSSLClientFilter() {
        return new TrustedSSLClientFilter();
    }

    public Filter webServicesAuthenticationFilter() {
        return new WebServicesAuthenticationFilter();
    }
}

