/*
 * Decompiled with CFR 0.152.
 */
package com.mediakind.contentapi.module.title.controller;

import com.mediakind.contentapi.enumeration.ResultCode;
import com.mediakind.contentapi.enumeration.StatusCode;
import com.mediakind.contentapi.module.title.model.dto.AssetFilter;
import com.mediakind.contentapi.module.title.model.entity.TitleDbEntity;
import com.mediakind.contentapi.module.title.model.vo.AssetsListOfPage;
import com.mediakind.contentapi.module.title.service.intf.IAssetService;
import com.mediakind.contentapi.vo.ResultVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Example;
import io.swagger.annotations.ExampleProperty;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"Asset Management"}, value="APIs about Asset Management")
@RestController
@RequestMapping(value={"/v1/assets"})
public class AssetController {
    private static final Logger log = LogManager.getLogger(AssetController.class);
    @Autowired
    private IAssetService assetService;

    @ApiOperation(value="Retrieves a list of assets", tags={"Asset Management"})
    @ApiResponses(value={@ApiResponse(code=200, message="OK", examples=@Example(value={@ExampleProperty(mediaType="application/json", value="Sample JSON Response when detail summary:\n{\n    \"code\": 200,\n    \"message\": \"OK\",\n    \"data\": {\n        \"page\": 0,\n        \"size\": 10,\n        \"assets\": [\n            {\n                \"id\": 1,\n                \"name\": \"cccccc\",\n                \"status\": \"Title - Committed\",\n                \"provider\": \"TTV\",\n                \"description\": \"aaa\",\n                \"runtime\": \"00:30:28\",\n                \"genre\": [\n                    \"PG\"\n                ],\n                \"rating\": [\n                    \"PG-13\"\n                ],\n                \"language\": [\n                    \"en-us\"\n                ],\n                \"last_modified_at\": 1673396788705,\n                \"created_at\": 1672786404938,\n                \"license_start_time\": 1672786404938,\n                \"license_end_time\": 1672786404938,\n                \"thumbnail\": \"/content/derived/TTV.COM/1/thumbnails/asset_6_1673409375398.png\",\n                \"playout_url\": \"https://azureblobip/fileurl\"\n            },{\n \n            }...\n        ],\n        \"total_count\": 999\n    }\n}"), @ExampleProperty(mediaType="application/json", value="Sample JSON Response when detail full:\n{\n    \"code\": 200,\n    \"message\": \"OK\",\n    \"data\": {\n        \"page\": 0,\n        \"size\": 10,\n        \"assets\": [\n            {\n                \"id\": 1,\n                \"name\": \"cccccc\",\n                \"status\": \"Title - Committed\",\n                \"provider\": \"TTV\",\n                \"description\": \"aaa\",\n                \"runtime\": \"00:30:28\",\n                \"genre\": [\n                    \"PG\"\n                ],\n                \"rating\": [\n                    \"PG-13\"\n                ],\n                \"language\": [\n                    \"en-us\"\n                ],\n                \"images\": [\n                    {\n                        \"id\": 5,\n                        \"file\": \"fileid-123123184y71982da\",\n                        \"type\": \"poster\",\n                        \"aspect_ratio\": \"3x3\",\n                        \"thumbnail\": \"/content/derived/TTV.COM/1/thumbnails/asset_5_1673409360829.png\"\n                    },\n                    {\n                        \"id\": 6,\n                        \"file\": \"fileid-123123184dasf2da\",\n                        \"type\": \"poster\",\n                        \"aspect_ratio\": \"4x3\",\n                        \"thumbnail\": \"/content/derived/TTV.COM/1/thumbnails/asset_6_1673409375398.png\"\n                    }\n                ],\n                \"videos\": [\n                    {\n                        \"id\": 2,\n                        \"file\": \"fileid-12af21314asd71982da\",\n                        \"type\": \"prime\",\n                        \"resolution\": \"1080x720\",\n                        \"size\": \"15615182\"\n                    }\n                ],\n                \"last_modified_at\": 1673396788705,\n                \"created_at\": 1672786404938,\n                \"license_start_time\": 1672786404938,\n                \"license_end_time\": 1672786404938,\n                \"thumbnail\": \"/content/derived/TTV.COM/1/thumbnails/asset_6_1673409375398.png\",\n                \"playout_url\": \"https://azureblobip/fileurl\"\n            },{\n\n            }...\n        ],\n        \"total_count\": 999\n    }\n}")})), @ApiResponse(code=204, message="No Content"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=500, message="Internal Server Error")})
    @PostMapping(path={"/searches"}, produces={"application/json"}, consumes={"application/json"})
    public ResultVo listAssets(@RequestBody AssetFilter assetFilter, HttpServletResponse response) throws Exception {
        AssetsListOfPage assetsListOfPage = new AssetsListOfPage();
        Map objectMap = this.assetService.listAssets(assetFilter);
        List assetsList = (List)objectMap.get("assetsList");
        Long totalCount = (Long)objectMap.get("totalCount");
        assetsListOfPage.setAssets(assetsList);
        assetsListOfPage.setTotalCount(Integer.valueOf(totalCount.intValue()));
        assetsListOfPage.setStart(Integer.valueOf(Integer.parseInt(assetFilter.getPagination().getStart())));
        assetsListOfPage.setSize(Integer.valueOf(Integer.parseInt(assetFilter.getPagination().getSize())));
        if (assetsList.isEmpty()) {
            response.setStatus(ResultCode.NO_CONTENT.getCode());
            return new ResultVo((StatusCode)ResultCode.NO_CONTENT, (Object)assetsListOfPage);
        }
        return new ResultVo((Object)assetsListOfPage);
    }

    @ApiOperation(value="Get Asset")
    @GetMapping(value={"/{id}"})
    public TitleDbEntity getAsset(@PathVariable String id) {
        log.info("new api  ----  Get assets");
        return null;
    }

    @ApiOperation(value="Create Asset")
    @PostMapping
    public List<TitleDbEntity> createAsset() {
        return null;
    }

    @ApiOperation(value="Update Asset")
    @PutMapping(value={"/{id}"})
    public List<TitleDbEntity> updateAsset() {
        return null;
    }

    @ApiOperation(value="Delete Asset")
    @DeleteMapping(value={"/{id}"})
    public List<TitleDbEntity> deleteAsset() {
        return null;
    }
}

