/*
 * Decompiled with CFR 0.152.
 */
package com.mediakind.contentapi.module.title.service.impl;

import com.mediakind.contentapi.exp.UnsupportFieldOrOperatorException;
import com.mediakind.contentapi.module.title.model.dto.AssetFilter;
import com.mediakind.contentapi.module.title.model.entity.TitleEsEntity;
import com.mediakind.contentapi.module.title.service.intf.IElasticSearchService;
import com.mediakind.contentapi.module.title.service.search.ElasticSearchHelper;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.core.ReactiveElasticsearchOperations;
import org.springframework.data.elasticsearch.core.SearchHit;
import org.springframework.data.elasticsearch.core.SearchPage;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.stereotype.Service;

@Service
public class ElasticSearchServiceImpl
implements IElasticSearchService {
    private static final Logger log = LogManager.getLogger(ElasticSearchServiceImpl.class);
    @Autowired
    ElasticSearchHelper elasticSearchHelper;
    @Autowired
    ReactiveElasticsearchOperations reactiveElasticsearchOperations;

    public Map<String, Object> searchTitle(AssetFilter assetFilter) throws UnsupportFieldOrOperatorException {
        HashMap<String, Object> esObject = new HashMap<String, Object>();
        Query query = this.elasticSearchHelper.buildQuery(assetFilter);
        SearchPage searchPage = (SearchPage)this.reactiveElasticsearchOperations.searchForPage(query, TitleEsEntity.class).block();
        if (searchPage != null) {
            List titleEsEntities = searchPage.getContent().stream().map(SearchHit::getContent).collect(Collectors.toList());
            esObject.put("esEntity", titleEsEntities);
            esObject.put("totalCount", searchPage.getTotalElements());
        }
        return esObject;
    }
}

