/*
 * Decompiled with CFR 0.152.
 */
package com.mediakind.contentapi.module.title.service.search;

import com.mediakind.contentapi.exp.UnsupportFieldOrOperatorException;
import com.mediakind.contentapi.module.title.model.dto.Filter;
import com.mediakind.contentapi.module.title.util.DataTypeMappingReader;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.elasticsearch.core.query.Criteria;

public class CriteriaBuilder {
    private static final Logger log = LogManager.getLogger(CriteriaBuilder.class);
    private static final String STRING_TYPES = "string";
    private static final String LIST_TYPES = "list";
    private static final String STRING_OPERATOR = "EQUAL, NOTEQUAL, IN, NOTIN, CONTAINS, MATCHES";
    private static final String LIST_OPERATOR = "IN, NOTIN";
    private Criteria criteria;
    private Criteria orCriteria;

    public CriteriaBuilder() {
    }

    public CriteriaBuilder(Criteria criteria) {
        this.criteria = criteria;
    }

    private CriteriaBuilder lessThanCriteria(String field, Object value, boolean isAnd) {
        Criteria newCriteria = new Criteria(field);
        if (isAnd) {
            this.criteria = this.criteria == null ? newCriteria.lessThan(value) : this.criteria.and(newCriteria.lessThan(value));
        } else {
            this.orCriteria = this.orCriteria == null ? newCriteria.lessThan(value) : this.orCriteria.or(newCriteria.lessThan(value));
        }
        return this;
    }

    private CriteriaBuilder lessThanEqualCriteria(String field, Object value, boolean isAnd) {
        Criteria newCriteria = new Criteria(field);
        if (isAnd) {
            this.criteria = this.criteria == null ? newCriteria.lessThanEqual(value) : this.criteria.and(newCriteria.lessThanEqual(value));
        } else {
            this.orCriteria = this.orCriteria == null ? newCriteria.lessThanEqual(value) : this.orCriteria.or(newCriteria.lessThanEqual(value));
        }
        return this;
    }

    private CriteriaBuilder greaterThanCriteria(String field, Object value, boolean isAnd) {
        Criteria newCriteria = new Criteria(field);
        if (isAnd) {
            this.criteria = this.criteria == null ? newCriteria.greaterThan(value) : this.criteria.and(newCriteria.greaterThan(value));
        } else {
            this.orCriteria = this.orCriteria == null ? newCriteria.greaterThan(value) : this.orCriteria.or(newCriteria.greaterThan(value));
        }
        return this;
    }

    private CriteriaBuilder greaterThanEqualCriteria(String field, Object value, boolean isAnd) {
        Criteria newCriteria = new Criteria(field);
        if (isAnd) {
            this.criteria = this.criteria == null ? newCriteria.greaterThanEqual(value) : this.criteria.and(newCriteria.greaterThanEqual(value));
        } else {
            this.orCriteria = this.orCriteria == null ? newCriteria.greaterThanEqual(value) : this.orCriteria.or(newCriteria.greaterThanEqual(value));
        }
        return this;
    }

    private CriteriaBuilder containsCriteria(String field, Object value, boolean isAnd) {
        Criteria newCriteria = new Criteria(field);
        if (isAnd) {
            this.criteria = this.criteria == null ? newCriteria.contains(String.valueOf(value)) : this.criteria.and(newCriteria.contains(String.valueOf(value)));
        } else {
            this.orCriteria = this.orCriteria == null ? newCriteria.contains(String.valueOf(value)) : this.orCriteria.or(newCriteria.contains(String.valueOf(value)));
        }
        return this;
    }

    private CriteriaBuilder inCriteria(String field, Object value, boolean isNot, boolean isAnd) {
        Criteria newCriteria = new Criteria(field);
        if (isAnd) {
            this.criteria = isNot ? (this.criteria == null ? newCriteria.notIn((Iterable)((List)value)) : this.criteria.and(newCriteria.notIn((Iterable)((List)value)))) : (this.criteria == null ? newCriteria.in((Iterable)((List)value)) : this.criteria.and(newCriteria.in((Iterable)((List)value))));
        } else {
            this.orCriteria = isNot ? (this.orCriteria == null ? newCriteria.notIn((Iterable)((List)value)) : this.orCriteria.or(newCriteria.notIn((Iterable)((List)value)))) : (this.orCriteria == null ? newCriteria.in((Iterable)((List)value)) : this.orCriteria.or(newCriteria.in((Iterable)((List)value))));
        }
        return this;
    }

    public CriteriaBuilder equalCriteria(String field, Object value, boolean isNot, boolean isAnd) {
        Criteria newCriteria = new Criteria(field);
        if (isNot) {
            newCriteria.not();
        }
        if (isAnd) {
            this.criteria = this.criteria == null ? newCriteria.is(value) : this.criteria.and(newCriteria.is(value));
        } else {
            this.orCriteria = this.orCriteria == null ? newCriteria.is(value) : this.orCriteria.or(newCriteria.is(value));
        }
        return this;
    }

    private CriteriaBuilder matchesCriteria(String field, Object value, boolean isAnd) {
        Criteria newCriteria = new Criteria(field);
        if (isAnd) {
            this.criteria = this.criteria == null ? newCriteria.matches(value) : this.criteria.and(newCriteria.matches(value));
        } else {
            this.orCriteria = this.orCriteria == null ? newCriteria.matches(value) : this.orCriteria.or(newCriteria.matches(value));
        }
        return this;
    }

    private void operatorValidator(Filter filter, String field, String dataType) throws UnsupportFieldOrOperatorException {
        String operator = filter.getOperator().toUpperCase();
        Object value = filter.getValue();
        if (!LIST_OPERATOR.contains(operator) && value instanceof List) {
            throw new UnsupportFieldOrOperatorException(String.format("This operator:[%s] do not support the type:[List] of value", operator));
        }
        if (LIST_OPERATOR.contains(operator) && (value instanceof String || value instanceof Integer)) {
            filter.setValue(Collections.singletonList(value));
        }
        if (STRING_TYPES.equals(dataType) && !STRING_OPERATOR.contains(operator) || LIST_TYPES.equals(dataType) && !LIST_OPERATOR.contains(operator)) {
            throw new UnsupportFieldOrOperatorException(String.format("This field:[%s] do not support the operator:[%s]", field, operator));
        }
    }

    public CriteriaBuilder operatorAdaptor(Filter filter, DataTypeMappingReader dataTypeMappingReader, boolean isAnd) throws UnsupportFieldOrOperatorException {
        String operator = filter.getOperator().toUpperCase();
        String field = dataTypeMappingReader.getEsEntityFieldName(filter.getField());
        this.operatorValidator(filter, dataTypeMappingReader.getEsEntityFieldName(filter.getField()), dataTypeMappingReader.getDataType(filter.getField()));
        Object value = filter.getValue();
        switch (operator) {
            case "IN": {
                return this.inCriteria(field, value, false, isAnd);
            }
            case "NOTIN": {
                return this.inCriteria(field, value, true, isAnd);
            }
            case "EQUAL": {
                return this.equalCriteria(field, value, false, isAnd);
            }
            case "NOTEQUAL": {
                return this.equalCriteria(field, value, true, isAnd);
            }
            case "CONTAINS": {
                return this.containsCriteria(field, value, isAnd);
            }
            case "LESSTHAN": {
                return this.lessThanCriteria(field, value, isAnd);
            }
            case "LESSTHANEQUAL": {
                return this.lessThanEqualCriteria(field, value, isAnd);
            }
            case "GREATERTHAN": {
                return this.greaterThanCriteria(field, value, isAnd);
            }
            case "GREATERTHANEQUAL": {
                return this.greaterThanEqualCriteria(field, value, isAnd);
            }
            case "MATCHES": {
                return this.matchesCriteria(field, value, isAnd);
            }
        }
        throw new UnsupportFieldOrOperatorException(String.format("Do not support operator:[%s]", operator));
    }

    public Criteria build() {
        if (this.orCriteria != null) {
            return this.criteria.subCriteria(this.orCriteria);
        }
        return this.criteria;
    }
}

