/*
 * Decompiled with CFR 0.152.
 */
package com.mediakind.contentapi.module.title.service.search;

import com.mediakind.contentapi.exp.UnsupportFieldOrOperatorException;
import com.mediakind.contentapi.module.title.mapper.TitleMapper;
import com.mediakind.contentapi.module.title.model.dto.AssetFilter;
import com.mediakind.contentapi.module.title.model.dto.Filter;
import com.mediakind.contentapi.module.title.service.search.CriteriaBuilder;
import com.mediakind.contentapi.module.title.util.DataTypeMappingReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.elasticsearch.core.query.Criteria;
import org.springframework.data.elasticsearch.core.query.CriteriaQuery;
import org.springframework.data.elasticsearch.core.query.Order;
import org.springframework.data.elasticsearch.core.query.Query;
import org.springframework.stereotype.Component;

@Component
public class ElasticSearchHelper {
    public static final String INIT_PAGE = "0";
    public static final String INIT_SIZE = "10";
    public static final String CONTENT_CLASS_ID = "contentClassId";
    @Autowired
    DataTypeMappingReader dataTypeMappingReader;
    @Autowired
    TitleMapper titleMapper;

    public Query buildQuery(AssetFilter assetFilter) throws UnsupportFieldOrOperatorException {
        CriteriaBuilder criteriaBuilder = this.setContentClassCriteria(assetFilter.getFilters());
        AssetFilter.Filters filters = assetFilter.getFilters();
        for (Filter filter : filters.getAndFilter()) {
            criteriaBuilder.operatorAdaptor(filter, this.dataTypeMappingReader, true);
        }
        for (Filter filter : filters.getOrFilter()) {
            criteriaBuilder.operatorAdaptor(filter, this.dataTypeMappingReader, false);
        }
        String keyword = assetFilter.getKeyword();
        if (!keyword.isEmpty()) {
            criteriaBuilder.operatorAdaptor(new Filter("quickSearch", "MATCHES", (Object)keyword), this.dataTypeMappingReader, true);
        }
        int page = Integer.parseInt(Optional.ofNullable(assetFilter.getPagination().getStart()).orElse(INIT_PAGE));
        int size = Integer.parseInt(Optional.ofNullable(assetFilter.getPagination().getSize()).orElse(INIT_SIZE));
        this.validatedPagination(page, size, assetFilter.getDetail());
        ArrayList<Order> orders = new ArrayList<Order>();
        CriteriaQuery query = new CriteriaQuery(criteriaBuilder.build());
        List sorts = assetFilter.getSorts();
        if (sorts != null && !sorts.isEmpty()) {
            for (AssetFilter.Sort sort : sorts) {
                orders.add(new Order(Sort.Direction.valueOf((String)sort.getOrder().toUpperCase()), this.dataTypeMappingReader.getEsEntityFieldName(sort.getSortBy())));
            }
        } else {
            orders.add(new Order(Sort.Direction.DESC, "id"));
        }
        query.setPageable((Pageable)PageRequest.of((int)page, (int)size, (Sort)Sort.by(orders)));
        return query;
    }

    private void validatedPagination(int page, int size, String detail) throws UnsupportFieldOrOperatorException {
        if (size > 100) {
            throw new UnsupportFieldOrOperatorException("The maximum size of page is 100 when the detail is summary");
        }
        if (page < 0) {
            throw new UnsupportFieldOrOperatorException("The start number can not be a negative");
        }
        if ("full".equals(detail) && size > 10) {
            throw new UnsupportFieldOrOperatorException("The maximum size of page is 10 when the detail is full");
        }
    }

    /*
     * WARNING - void declaration
     */
    private CriteriaBuilder setContentClassCriteria(AssetFilter.Filters filters) throws UnsupportFieldOrOperatorException {
        CriteriaBuilder criteriaBuilder;
        ArrayList<Object> andContentClassFilters = new ArrayList<Object>();
        List andFilters = filters.getAndFilter();
        List orFilters = filters.getOrFilter();
        Iterator iterator = andFilters.iterator();
        while (iterator.hasNext()) {
            void var8_7;
            Filter filter = (Filter)iterator.next();
            if (!"contentClassName".equals(filter.getField())) continue;
            Object contentClassNames = filter.getValue();
            if (contentClassNames instanceof List) {
                ArrayList arrayList = new ArrayList();
                for (String contentClassName : (List)contentClassNames) {
                    ((List)arrayList).add(this.titleMapper.getContentClassIdByName(contentClassName).toString());
                }
            } else {
                Integer n = this.titleMapper.getContentClassIdByName(contentClassNames.toString());
            }
            filter.setValue((Object)var8_7);
            filter.setField(CONTENT_CLASS_ID);
            andContentClassFilters.add(filter);
            iterator.remove();
        }
        for (Filter filter : orFilters) {
            if (!"contentClassName".equals(filter.getField())) continue;
            filter.setValue((Object)this.titleMapper.getContentClassIdByName(filter.getValue().toString()));
            filter.setField(CONTENT_CLASS_ID);
        }
        if (!andContentClassFilters.isEmpty()) {
            criteriaBuilder = new CriteriaBuilder();
            for (Filter filter : andContentClassFilters) {
                criteriaBuilder.operatorAdaptor(filter, this.dataTypeMappingReader, true);
            }
        } else {
            Criteria criteria = new Criteria(CONTENT_CLASS_ID).is((Object)"1");
            criteriaBuilder = new CriteriaBuilder(criteria);
        }
        return criteriaBuilder;
    }
}

