/*
 * Decompiled with CFR 0.152.
 */
package com.mediakind.contentapi.module.title.util;

import com.mediakind.contentapi.module.title.model.enumeration.ImageType;
import com.mediakind.contentapi.module.title.model.enumeration.VideoType;
import com.mediakind.contentapi.module.title.model.vo.AssetFullVo;
import com.mediakind.contentapi.module.title.model.vo.ImageVo;
import com.mediakind.contentapi.module.title.model.vo.VideoVo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

/*
 * Exception performing whole class analysis ignored.
 */
public class TitleXmlParse {
    public static final String FIELDS = "Fields";

    private TitleXmlParse() {
    }

    public static void parseImagesAndVideosFromTitleXml(AssetFullVo assetFullVo, String xml) throws DocumentException {
        List posterNodes;
        SAXReader reader = new SAXReader();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes());
        Document document = reader.read((InputStream)inputStream);
        List movieNodes = document.getRootElement().selectNodes("/ECMFSpec/Package/Movie");
        if (!movieNodes.isEmpty()) {
            assetFullVo.setVideos(TitleXmlParse.parseMovieNodes((List)movieNodes));
        }
        if (!(posterNodes = document.getRootElement().selectNodes("/ECMFSpec/Package/Poster")).isEmpty()) {
            assetFullVo.setImages(TitleXmlParse.parsePosterNodes((List)posterNodes));
        }
    }

    private static List<VideoVo> parseMovieNodes(List<Node> children) {
        ArrayList<VideoVo> videoVoList = new ArrayList<VideoVo>();
        for (Node child : children) {
            String sourceAssetId = TitleXmlParse.getTextFromNode((String)"Fields/Derived/SourceAssetId", (Node)child);
            if (sourceAssetId != null && TitleXmlParse.isPositiveInteger((String)sourceAssetId)) continue;
            VideoVo videoVo = new VideoVo();
            videoVo.setType(VideoType.PRIME.name().toLowerCase());
            videoVo.setId(Integer.parseInt(((Element)child).attributeValue("assetId")));
            videoVo.setSize(TitleXmlParse.getTextFromNode((String)"Fields/Content/SizeInBytes", (Node)child));
            videoVo.setResolution(TitleXmlParse.getTextFromNode((String)"Fields/Content/Resolution", (Node)child));
            videoVoList.add(videoVo);
        }
        return videoVoList;
    }

    private static List<ImageVo> parsePosterNodes(List<Node> children) {
        ArrayList<ImageVo> imageVoList = new ArrayList<ImageVo>();
        for (Node child : children) {
            ImageVo imageVo = new ImageVo();
            String imageType = TitleXmlParse.getTextFromNode((String)"Fields/PosterImageType", (Node)child);
            if ("poster".equalsIgnoreCase(imageType)) {
                imageVo.setType(ImageType.POSTER.name().toLowerCase());
            } else {
                if (!"keyart".equalsIgnoreCase(imageType)) continue;
                imageVo.setType(ImageType.KEYART.name().toLowerCase());
            }
            imageVo.setId(Integer.parseInt(((Element)child).attributeValue("assetId")));
            imageVo.setAspectRatio(TitleXmlParse.getTextFromNode((String)"Fields/Image/AspectRatio", (Node)child));
            imageVoList.add(imageVo);
        }
        return imageVoList;
    }

    private static boolean isPositiveInteger(String input) {
        Matcher mer = Pattern.compile("^[0-9]+$").matcher(input);
        return mer.find();
    }

    private static String getTextFromNode(String xpath, Node node) {
        List nodeList = node.selectNodes(xpath);
        if (nodeList.isEmpty()) {
            return null;
        }
        return ((Node)nodeList.get(0)).getText();
    }
}

