/*
 * Decompiled with CFR 0.152.
 */
package com.mediakind.contentapi.config;

import com.mediakind.neptune.common.util.PropertyFileReader;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.servers.ServerVariable;
import io.swagger.v3.oas.models.servers.ServerVariables;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Component;
import springfox.documentation.oas.web.OpenApiTransformationContext;
import springfox.documentation.oas.web.WebMvcOpenApiTransformationFilter;
import springfox.documentation.spi.DocumentationType;

@Component
public class SpringfoxSwaggerServerResolver
implements WebMvcOpenApiTransformationFilter {
    public static final String INSTALL_FOLDER_PROPERTY = "com.tandbergtv.cms.product.dir";
    public static final String PRODUCT_FILE = "product.properties";
    public static final String KEY_PRODUCT_VERSION = "product.version";

    public OpenAPI transform(OpenApiTransformationContext<HttpServletRequest> context) {
        OpenAPI swagger = context.getSpecification();
        String version = this.getProductVersionFromFile();
        swagger.getInfo().setVersion(version);
        Server server = new Server();
        ServerVariables serverVariables = new ServerVariables();
        ServerVariable host = new ServerVariable();
        host.setDefault(((HttpServletRequest)context.request().get()).getServerName());
        serverVariables.addServerVariable("host", host);
        ServerVariable port = new ServerVariable();
        port.setDefault("8443");
        serverVariables.addServerVariable("port", port);
        server.setUrl("https://{host}:{port}");
        server.setVariables(serverVariables);
        swagger.setServers(Arrays.asList(server));
        return swagger;
    }

    public boolean supports(DocumentationType docType) {
        return docType.equals((Object)DocumentationType.OAS_30);
    }

    private String getProductVersionFromFile() {
        File productFile = new File(System.getProperty(INSTALL_FOLDER_PROPERTY), PRODUCT_FILE);
        Map properties = PropertyFileReader.readProperties((File)productFile);
        return (String)properties.get(KEY_PRODUCT_VERSION);
    }
}

