/*
 * Decompiled with CFR 0.152.
 */
package com.mediakind.contentapi.config;

import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import springfox.documentation.builders.ApiInfoBuilder;
import springfox.documentation.builders.PathSelectors;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.AuthorizationScope;
import springfox.documentation.service.HttpAuthenticationScheme;
import springfox.documentation.service.SecurityReference;
import springfox.documentation.service.SecurityScheme;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.contexts.SecurityContext;
import springfox.documentation.spring.web.plugins.Docket;

@Configuration
public class Swagger3Config {
    @Bean
    public Docket createRestApi() {
        return new Docket(DocumentationType.OAS_30).groupName("Content-New").apiInfo(this.apiInfo()).securitySchemes(this.securitySchemes()).securityContexts(Arrays.asList(this.securityContext())).select().apis(RequestHandlerSelectors.withMethodAnnotation(ApiOperation.class)).paths(PathSelectors.any()).build();
    }

    private ApiInfo apiInfo() {
        return new ApiInfoBuilder().title("Content APIS for CMS New UI").description("API Management of CMS New UI").version("1.0").build();
    }

    private List<SecurityScheme> securitySchemes() {
        ArrayList<SecurityScheme> securitySchemes = new ArrayList<SecurityScheme>();
        securitySchemes.add((SecurityScheme)HttpAuthenticationScheme.BASIC_AUTH_BUILDER.name("basicAuth").build());
        return securitySchemes;
    }

    private List<SecurityReference> securityReferences() {
        AuthorizationScope authorizationScope = new AuthorizationScope("global", "accessEverything");
        AuthorizationScope[] authorizationScopes = new AuthorizationScope[]{authorizationScope};
        ArrayList<SecurityReference> securityReferences = new ArrayList<SecurityReference>();
        securityReferences.add(new SecurityReference("basicAuth", authorizationScopes));
        return securityReferences;
    }

    private SecurityContext securityContext() {
        return SecurityContext.builder().securityReferences(this.securityReferences()).forPaths(PathSelectors.any()).build();
    }
}

